<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for script StructType
 * @subpackage Structs
 */
class Script extends AbstractStructBase
{
    /**
     * The engine
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $engine;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * Constructor method for script
     * @uses Script::setEngine()
     * @uses Script::setName()
     * @param string $engine
     * @param string $name
     */
    public function __construct($engine = null, $name = null)
    {
        $this
            ->setEngine($engine)
            ->setName($name);
    }
    /**
     * Get engine value
     * @return string
     */
    public function getEngine()
    {
        return $this->engine;
    }
    /**
     * Set engine value
     * @param string $engine
     * @return \StructType\Script
     */
    public function setEngine($engine = null)
    {
        // validation for constraint: string
        if (!is_null($engine) && !is_string($engine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engine, true), gettype($engine)), __LINE__);
        }
        $this->engine = $engine;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Script
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
