<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesAgentType StructType
 * Meta information extracted from the WSDL
 * - documentation: An individual conducting sales activities on behalf of a sales branch or organization.
 * @subpackage Structs
 */
class SalesAgentType extends AbstractStructBase
{
    /**
     * The SalesAgentID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier of the sales agent. This value must be accompanied by the appropriate Sales Branch Identifier or Organization Identifier to ensure uniqueness. | An identifier is a character string used to uniquely identify one
     * instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesAgentID;
    /**
     * Constructor method for SalesAgentType
     * @uses SalesAgentType::setSalesAgentID()
     * @param string $salesAgentID
     */
    public function __construct($salesAgentID = null)
    {
        $this
            ->setSalesAgentID($salesAgentID);
    }
    /**
     * Get SalesAgentID value
     * @return string
     */
    public function getSalesAgentID()
    {
        return $this->SalesAgentID;
    }
    /**
     * Set SalesAgentID value
     * @param string $salesAgentID
     * @return \StructType\SalesAgentType
     */
    public function setSalesAgentID($salesAgentID = null)
    {
        // validation for constraint: string
        if (!is_null($salesAgentID) && !is_string($salesAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesAgentID, true), gettype($salesAgentID)), __LINE__);
        }
        $this->SalesAgentID = $salesAgentID;
        return $this;
    }
}
