<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RulesPenaltyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to a punishment imposed for breaking a law, rule, or contract.
 * @subpackage Structs
 */
class RulesPenaltyType extends AbstractStructBase
{
    /**
     * The PenaltyID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of this Penalty instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PenaltyID;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Penalty type information. Examples: Cancellation, Change, NoShow, Upgrade, Other | Penalty Type Code
     * - base: PenaltyTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeCode;
    /**
     * The AppCode
     * Meta information extracted from the WSDL
     * - documentation: Penalty application type. Examples: ADE (After departure) NOS (No show) PDE (Prior to departure) | Enumeration set for Penalty Application. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}PADIS - FAT{/codeListName}
     * {codeListIdentifier}FAT{/codeListIdentifier} | Penalty application code
     * - base: PenaltyAppCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppCode;
    /**
     * The CancelFeeInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, Cancellation fee(s) may apply. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CancelFeeInd;
    /**
     * The ChangeFeeInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, Change of Itinerary fee(s) may apply. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ChangeFeeInd;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description of the applicable penalty. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $DescText;
    /**
     * The NetInd
     * Meta information extracted from the WSDL
     * - documentation: The airline informs the seller if the penalty is netted (True) (i.e. taken from any amount that airline will owe to customer consequently to the servicing) or to be paid (False) (i.e. charged to customer upfront any servicing action,
     * and even if customer benefits from a subsequent refund/ residual value). | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NetInd;
    /**
     * The PenaltyPercent
     * Meta information extracted from the WSDL
     * - documentation: Percentage Value relating to acceptable the total amount by which the Order item price can vary; OR the amount of a penalty. Example: 20 USD, 2 Percent | A percent is a value representing a fraction of one hundred,expressed as a
     * quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PenaltyPercent;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: This is a specialization of price when associated with a Penalty Base definition is: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PenaltyPriceType
     */
    public $Price;
    /**
     * The RulesFareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RulesFareDetailType[]
     */
    public $RulesFareDetail;
    /**
     * The UpgradeFeeInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, Upgrade fee(s) may apply. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UpgradeFeeInd;
    /**
     * Constructor method for RulesPenaltyType
     * @uses RulesPenaltyType::setPenaltyID()
     * @uses RulesPenaltyType::setTypeCode()
     * @uses RulesPenaltyType::setAppCode()
     * @uses RulesPenaltyType::setCancelFeeInd()
     * @uses RulesPenaltyType::setChangeFeeInd()
     * @uses RulesPenaltyType::setDescText()
     * @uses RulesPenaltyType::setNetInd()
     * @uses RulesPenaltyType::setPenaltyPercent()
     * @uses RulesPenaltyType::setPrice()
     * @uses RulesPenaltyType::setRulesFareDetail()
     * @uses RulesPenaltyType::setUpgradeFeeInd()
     * @param string $penaltyID
     * @param string $typeCode
     * @param string $appCode
     * @param bool $cancelFeeInd
     * @param bool $changeFeeInd
     * @param string[] $descText
     * @param bool $netInd
     * @param float $penaltyPercent
     * @param \StructType\PenaltyPriceType $price
     * @param \StructType\RulesFareDetailType[] $rulesFareDetail
     * @param bool $upgradeFeeInd
     */
    public function __construct($penaltyID = null, $typeCode = null, $appCode = null, $cancelFeeInd = null, $changeFeeInd = null, array $descText = array(), $netInd = null, $penaltyPercent = null, \StructType\PenaltyPriceType $price = null, array $rulesFareDetail = array(), $upgradeFeeInd = null)
    {
        $this
            ->setPenaltyID($penaltyID)
            ->setTypeCode($typeCode)
            ->setAppCode($appCode)
            ->setCancelFeeInd($cancelFeeInd)
            ->setChangeFeeInd($changeFeeInd)
            ->setDescText($descText)
            ->setNetInd($netInd)
            ->setPenaltyPercent($penaltyPercent)
            ->setPrice($price)
            ->setRulesFareDetail($rulesFareDetail)
            ->setUpgradeFeeInd($upgradeFeeInd);
    }
    /**
     * Get PenaltyID value
     * @return string
     */
    public function getPenaltyID()
    {
        return $this->PenaltyID;
    }
    /**
     * Set PenaltyID value
     * @param string $penaltyID
     * @return \StructType\RulesPenaltyType
     */
    public function setPenaltyID($penaltyID = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyID) && !is_string($penaltyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyID, true), gettype($penaltyID)), __LINE__);
        }
        $this->PenaltyID = $penaltyID;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\RulesPenaltyType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get AppCode value
     * @return string|null
     */
    public function getAppCode()
    {
        return $this->AppCode;
    }
    /**
     * Set AppCode value
     * @param string $appCode
     * @return \StructType\RulesPenaltyType
     */
    public function setAppCode($appCode = null)
    {
        // validation for constraint: string
        if (!is_null($appCode) && !is_string($appCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appCode, true), gettype($appCode)), __LINE__);
        }
        $this->AppCode = $appCode;
        return $this;
    }
    /**
     * Get CancelFeeInd value
     * @return bool|null
     */
    public function getCancelFeeInd()
    {
        return $this->CancelFeeInd;
    }
    /**
     * Set CancelFeeInd value
     * @param bool $cancelFeeInd
     * @return \StructType\RulesPenaltyType
     */
    public function setCancelFeeInd($cancelFeeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelFeeInd) && !is_bool($cancelFeeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelFeeInd, true), gettype($cancelFeeInd)), __LINE__);
        }
        $this->CancelFeeInd = $cancelFeeInd;
        return $this;
    }
    /**
     * Get ChangeFeeInd value
     * @return bool|null
     */
    public function getChangeFeeInd()
    {
        return $this->ChangeFeeInd;
    }
    /**
     * Set ChangeFeeInd value
     * @param bool $changeFeeInd
     * @return \StructType\RulesPenaltyType
     */
    public function setChangeFeeInd($changeFeeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeFeeInd) && !is_bool($changeFeeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changeFeeInd, true), gettype($changeFeeInd)), __LINE__);
        }
        $this->ChangeFeeInd = $changeFeeInd;
        return $this;
    }
    /**
     * Get DescText value
     * @return string[]|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * This method is responsible for validating the values passed to the setDescText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescTextForArrayConstraintsFromSetDescText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesPenaltyTypeDescTextItem) {
            // validation for constraint: itemType
            if (!is_string($rulesPenaltyTypeDescTextItem)) {
                $invalidValues[] = is_object($rulesPenaltyTypeDescTextItem) ? get_class($rulesPenaltyTypeDescTextItem) : sprintf('%s(%s)', gettype($rulesPenaltyTypeDescTextItem), var_export($rulesPenaltyTypeDescTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DescText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DescText value
     * @throws \InvalidArgumentException
     * @param string[] $descText
     * @return \StructType\RulesPenaltyType
     */
    public function setDescText(array $descText = array())
    {
        // validation for constraint: array
        if ('' !== ($descTextArrayErrorMessage = self::validateDescTextForArrayConstraintsFromSetDescText($descText))) {
            throw new \InvalidArgumentException($descTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($descText) && count($descText) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Add item to DescText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RulesPenaltyType
     */
    public function addToDescText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DescText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->DescText) && count($this->DescText) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->DescText)), __LINE__);
        }
        $this->DescText[] = $item;
        return $this;
    }
    /**
     * Get NetInd value
     * @return bool|null
     */
    public function getNetInd()
    {
        return $this->NetInd;
    }
    /**
     * Set NetInd value
     * @param bool $netInd
     * @return \StructType\RulesPenaltyType
     */
    public function setNetInd($netInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($netInd) && !is_bool($netInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netInd, true), gettype($netInd)), __LINE__);
        }
        $this->NetInd = $netInd;
        return $this;
    }
    /**
     * Get PenaltyPercent value
     * @return float|null
     */
    public function getPenaltyPercent()
    {
        return $this->PenaltyPercent;
    }
    /**
     * Set PenaltyPercent value
     * @param float $penaltyPercent
     * @return \StructType\RulesPenaltyType
     */
    public function setPenaltyPercent($penaltyPercent = null)
    {
        // validation for constraint: float
        if (!is_null($penaltyPercent) && !(is_float($penaltyPercent) || is_numeric($penaltyPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltyPercent, true), gettype($penaltyPercent)), __LINE__);
        }
        $this->PenaltyPercent = $penaltyPercent;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PenaltyPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PenaltyPriceType $price
     * @return \StructType\RulesPenaltyType
     */
    public function setPrice(\StructType\PenaltyPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get RulesFareDetail value
     * @return \StructType\RulesFareDetailType[]|null
     */
    public function getRulesFareDetail()
    {
        return $this->RulesFareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRulesFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRulesFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRulesFareDetailForArrayConstraintsFromSetRulesFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rulesPenaltyTypeRulesFareDetailItem) {
            // validation for constraint: itemType
            if (!$rulesPenaltyTypeRulesFareDetailItem instanceof \StructType\RulesFareDetailType) {
                $invalidValues[] = is_object($rulesPenaltyTypeRulesFareDetailItem) ? get_class($rulesPenaltyTypeRulesFareDetailItem) : sprintf('%s(%s)', gettype($rulesPenaltyTypeRulesFareDetailItem), var_export($rulesPenaltyTypeRulesFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RulesFareDetail property can only contain items of type \StructType\RulesFareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RulesFareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesFareDetailType[] $rulesFareDetail
     * @return \StructType\RulesPenaltyType
     */
    public function setRulesFareDetail(array $rulesFareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($rulesFareDetailArrayErrorMessage = self::validateRulesFareDetailForArrayConstraintsFromSetRulesFareDetail($rulesFareDetail))) {
            throw new \InvalidArgumentException($rulesFareDetailArrayErrorMessage, __LINE__);
        }
        $this->RulesFareDetail = $rulesFareDetail;
        return $this;
    }
    /**
     * Add item to RulesFareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesFareDetailType $item
     * @return \StructType\RulesPenaltyType
     */
    public function addToRulesFareDetail(\StructType\RulesFareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RulesFareDetailType) {
            throw new \InvalidArgumentException(sprintf('The RulesFareDetail property can only contain items of type \StructType\RulesFareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RulesFareDetail[] = $item;
        return $this;
    }
    /**
     * Get UpgradeFeeInd value
     * @return bool|null
     */
    public function getUpgradeFeeInd()
    {
        return $this->UpgradeFeeInd;
    }
    /**
     * Set UpgradeFeeInd value
     * @param bool $upgradeFeeInd
     * @return \StructType\RulesPenaltyType
     */
    public function setUpgradeFeeInd($upgradeFeeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradeFeeInd) && !is_bool($upgradeFeeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradeFeeInd, true), gettype($upgradeFeeInd)), __LINE__);
        }
        $this->UpgradeFeeInd = $upgradeFeeInd;
        return $this;
    }
}
