<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetailerOrderInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: A retailer order info type
 * @subpackage Structs
 */
class RetailerOrderInfoType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceList
     * Meta information extracted from the WSDL
     * - documentation: Baggage allowance data list definition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageAllowanceListType
     */
    public $BaggageAllowanceList;
    /**
     * The BaggageDisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Baggage disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageDisclosureListType
     */
    public $BaggageDisclosureList;
    /**
     * The DisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DisclosureListType
     */
    public $DisclosureList;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The PaxSegmentList
     * Meta information extracted from the WSDL
     * - documentation: Segment data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentListType
     */
    public $PaxSegmentList;
    /**
     * The SeatProfileList
     * Meta information extracted from the WSDL
     * - documentation: Seat Profile data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SeatProfileListType
     */
    public $SeatProfileList;
    /**
     * The ServiceDefinitionList
     * Meta information extracted from the WSDL
     * - documentation: Service Definition data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDefinitionListType
     */
    public $ServiceDefinitionList;
    /**
     * Constructor method for RetailerOrderInfoType
     * @uses RetailerOrderInfoType::setBaggageAllowanceList()
     * @uses RetailerOrderInfoType::setBaggageDisclosureList()
     * @uses RetailerOrderInfoType::setDisclosureList()
     * @uses RetailerOrderInfoType::setPaxList()
     * @uses RetailerOrderInfoType::setPaxSegmentList()
     * @uses RetailerOrderInfoType::setSeatProfileList()
     * @uses RetailerOrderInfoType::setServiceDefinitionList()
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @param \StructType\DisclosureListType $disclosureList
     * @param \StructType\PaxListType $paxList
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @param \StructType\SeatProfileListType $seatProfileList
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     */
    public function __construct(\StructType\BaggageAllowanceListType $baggageAllowanceList = null, \StructType\BaggageDisclosureListType $baggageDisclosureList = null, \StructType\DisclosureListType $disclosureList = null, \StructType\PaxListType $paxList = null, \StructType\PaxSegmentListType $paxSegmentList = null, \StructType\SeatProfileListType $seatProfileList = null, \StructType\ServiceDefinitionListType $serviceDefinitionList = null)
    {
        $this
            ->setBaggageAllowanceList($baggageAllowanceList)
            ->setBaggageDisclosureList($baggageDisclosureList)
            ->setDisclosureList($disclosureList)
            ->setPaxList($paxList)
            ->setPaxSegmentList($paxSegmentList)
            ->setSeatProfileList($seatProfileList)
            ->setServiceDefinitionList($serviceDefinitionList);
    }
    /**
     * Get BaggageAllowanceList value
     * @return \StructType\BaggageAllowanceListType|null
     */
    public function getBaggageAllowanceList()
    {
        return $this->BaggageAllowanceList;
    }
    /**
     * Set BaggageAllowanceList value
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setBaggageAllowanceList(\StructType\BaggageAllowanceListType $baggageAllowanceList = null)
    {
        $this->BaggageAllowanceList = $baggageAllowanceList;
        return $this;
    }
    /**
     * Get BaggageDisclosureList value
     * @return \StructType\BaggageDisclosureListType|null
     */
    public function getBaggageDisclosureList()
    {
        return $this->BaggageDisclosureList;
    }
    /**
     * Set BaggageDisclosureList value
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setBaggageDisclosureList(\StructType\BaggageDisclosureListType $baggageDisclosureList = null)
    {
        $this->BaggageDisclosureList = $baggageDisclosureList;
        return $this;
    }
    /**
     * Get DisclosureList value
     * @return \StructType\DisclosureListType|null
     */
    public function getDisclosureList()
    {
        return $this->DisclosureList;
    }
    /**
     * Set DisclosureList value
     * @param \StructType\DisclosureListType $disclosureList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setDisclosureList(\StructType\DisclosureListType $disclosureList = null)
    {
        $this->DisclosureList = $disclosureList;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get PaxSegmentList value
     * @return \StructType\PaxSegmentListType|null
     */
    public function getPaxSegmentList()
    {
        return $this->PaxSegmentList;
    }
    /**
     * Set PaxSegmentList value
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setPaxSegmentList(\StructType\PaxSegmentListType $paxSegmentList = null)
    {
        $this->PaxSegmentList = $paxSegmentList;
        return $this;
    }
    /**
     * Get SeatProfileList value
     * @return \StructType\SeatProfileListType|null
     */
    public function getSeatProfileList()
    {
        return $this->SeatProfileList;
    }
    /**
     * Set SeatProfileList value
     * @param \StructType\SeatProfileListType $seatProfileList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setSeatProfileList(\StructType\SeatProfileListType $seatProfileList = null)
    {
        $this->SeatProfileList = $seatProfileList;
        return $this;
    }
    /**
     * Get ServiceDefinitionList value
     * @return \StructType\ServiceDefinitionListType|null
     */
    public function getServiceDefinitionList()
    {
        return $this->ServiceDefinitionList;
    }
    /**
     * Set ServiceDefinitionList value
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @return \StructType\RetailerOrderInfoType
     */
    public function setServiceDefinitionList(\StructType\ServiceDefinitionListType $serviceDefinitionList = null)
    {
        $this->ServiceDefinitionList = $serviceDefinitionList;
        return $this;
    }
}
