<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseParametersResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: A set of Information related to how response results should be returned.
 * @subpackage Structs
 */
class ResponseParametersResponseType extends AbstractStructBase
{
    /**
     * The BDC
     * Meta information extracted from the WSDL
     * - documentation: A carrier whose baggage allowances and charges apply.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BDC_Type
     */
    public $BDC;
    /**
     * The CurParameter
     * Meta information extracted from the WSDL
     * - documentation: Currency related parameters intended to influence which currency the shopping results are displayed in.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurParameterType[]
     */
    public $CurParameter;
    /**
     * The Device
     * Meta information extracted from the WSDL
     * - documentation: Device upon which the secure transaction will occur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceType
     */
    public $Device;
    /**
     * The LangUsage
     * Meta information extracted from the WSDL
     * - documentation: Language Code representation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LangUsageType[]
     */
    public $LangUsage;
    /**
     * The MarketingMessage
     * Meta information extracted from the WSDL
     * - documentation: Marketing message: Additional, supplementary information about the document or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketingMessageType[]
     */
    public $MarketingMessage;
    /**
     * The MeasurementSystemCode
     * Meta information extracted from the WSDL
     * - documentation: Measurement system code. Examples: Imperial, Metric | BDT to represent measurement system codes (e.g. Imperial, Metric).
     * - base: MeasurementSystemCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeasurementSystemCode;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * The PricingParameter
     * Meta information extracted from the WSDL
     * - documentation: Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Tax Exemption.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PricingParameterType
     */
    public $PricingParameter;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Should be used for the Seller to communicate the reason for cancellation to the Seller (and for the Airline to respond with advice on the cancellation request. Uses PADIS REA Codeset. | A code is a character string of letters,
     * numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonCode;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * Constructor method for ResponseParametersResponseType
     * @uses ResponseParametersResponseType::setBDC()
     * @uses ResponseParametersResponseType::setCurParameter()
     * @uses ResponseParametersResponseType::setDevice()
     * @uses ResponseParametersResponseType::setLangUsage()
     * @uses ResponseParametersResponseType::setMarketingMessage()
     * @uses ResponseParametersResponseType::setMeasurementSystemCode()
     * @uses ResponseParametersResponseType::setPaxGroup()
     * @uses ResponseParametersResponseType::setPricingParameter()
     * @uses ResponseParametersResponseType::setReasonCode()
     * @uses ResponseParametersResponseType::setRemark()
     * @param \StructType\BDC_Type $bDC
     * @param \StructType\CurParameterType[] $curParameter
     * @param \StructType\DeviceType $device
     * @param \StructType\LangUsageType[] $langUsage
     * @param \StructType\MarketingMessageType[] $marketingMessage
     * @param string $measurementSystemCode
     * @param \StructType\PaxGroupType $paxGroup
     * @param \StructType\PricingParameterType $pricingParameter
     * @param string $reasonCode
     * @param \StructType\RemarkType[] $remark
     */
    public function __construct(\StructType\BDC_Type $bDC = null, array $curParameter = array(), \StructType\DeviceType $device = null, array $langUsage = array(), array $marketingMessage = array(), $measurementSystemCode = null, \StructType\PaxGroupType $paxGroup = null, \StructType\PricingParameterType $pricingParameter = null, $reasonCode = null, array $remark = array())
    {
        $this
            ->setBDC($bDC)
            ->setCurParameter($curParameter)
            ->setDevice($device)
            ->setLangUsage($langUsage)
            ->setMarketingMessage($marketingMessage)
            ->setMeasurementSystemCode($measurementSystemCode)
            ->setPaxGroup($paxGroup)
            ->setPricingParameter($pricingParameter)
            ->setReasonCode($reasonCode)
            ->setRemark($remark);
    }
    /**
     * Get BDC value
     * @return \StructType\BDC_Type|null
     */
    public function getBDC()
    {
        return $this->BDC;
    }
    /**
     * Set BDC value
     * @param \StructType\BDC_Type $bDC
     * @return \StructType\ResponseParametersResponseType
     */
    public function setBDC(\StructType\BDC_Type $bDC = null)
    {
        $this->BDC = $bDC;
        return $this;
    }
    /**
     * Get CurParameter value
     * @return \StructType\CurParameterType[]|null
     */
    public function getCurParameter()
    {
        return $this->CurParameter;
    }
    /**
     * This method is responsible for validating the values passed to the setCurParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurParameterForArrayConstraintsFromSetCurParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseParametersResponseTypeCurParameterItem) {
            // validation for constraint: itemType
            if (!$responseParametersResponseTypeCurParameterItem instanceof \StructType\CurParameterType) {
                $invalidValues[] = is_object($responseParametersResponseTypeCurParameterItem) ? get_class($responseParametersResponseTypeCurParameterItem) : sprintf('%s(%s)', gettype($responseParametersResponseTypeCurParameterItem), var_export($responseParametersResponseTypeCurParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurParameter property can only contain items of type \StructType\CurParameterType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\CurParameterType[] $curParameter
     * @return \StructType\ResponseParametersResponseType
     */
    public function setCurParameter(array $curParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($curParameterArrayErrorMessage = self::validateCurParameterForArrayConstraintsFromSetCurParameter($curParameter))) {
            throw new \InvalidArgumentException($curParameterArrayErrorMessage, __LINE__);
        }
        $this->CurParameter = $curParameter;
        return $this;
    }
    /**
     * Add item to CurParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\CurParameterType $item
     * @return \StructType\ResponseParametersResponseType
     */
    public function addToCurParameter(\StructType\CurParameterType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurParameterType) {
            throw new \InvalidArgumentException(sprintf('The CurParameter property can only contain items of type \StructType\CurParameterType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurParameter[] = $item;
        return $this;
    }
    /**
     * Get Device value
     * @return \StructType\DeviceType|null
     */
    public function getDevice()
    {
        return $this->Device;
    }
    /**
     * Set Device value
     * @param \StructType\DeviceType $device
     * @return \StructType\ResponseParametersResponseType
     */
    public function setDevice(\StructType\DeviceType $device = null)
    {
        $this->Device = $device;
        return $this;
    }
    /**
     * Get LangUsage value
     * @return \StructType\LangUsageType[]|null
     */
    public function getLangUsage()
    {
        return $this->LangUsage;
    }
    /**
     * This method is responsible for validating the values passed to the setLangUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLangUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLangUsageForArrayConstraintsFromSetLangUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseParametersResponseTypeLangUsageItem) {
            // validation for constraint: itemType
            if (!$responseParametersResponseTypeLangUsageItem instanceof \StructType\LangUsageType) {
                $invalidValues[] = is_object($responseParametersResponseTypeLangUsageItem) ? get_class($responseParametersResponseTypeLangUsageItem) : sprintf('%s(%s)', gettype($responseParametersResponseTypeLangUsageItem), var_export($responseParametersResponseTypeLangUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LangUsage property can only contain items of type \StructType\LangUsageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LangUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\LangUsageType[] $langUsage
     * @return \StructType\ResponseParametersResponseType
     */
    public function setLangUsage(array $langUsage = array())
    {
        // validation for constraint: array
        if ('' !== ($langUsageArrayErrorMessage = self::validateLangUsageForArrayConstraintsFromSetLangUsage($langUsage))) {
            throw new \InvalidArgumentException($langUsageArrayErrorMessage, __LINE__);
        }
        $this->LangUsage = $langUsage;
        return $this;
    }
    /**
     * Add item to LangUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\LangUsageType $item
     * @return \StructType\ResponseParametersResponseType
     */
    public function addToLangUsage(\StructType\LangUsageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LangUsageType) {
            throw new \InvalidArgumentException(sprintf('The LangUsage property can only contain items of type \StructType\LangUsageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LangUsage[] = $item;
        return $this;
    }
    /**
     * Get MarketingMessage value
     * @return \StructType\MarketingMessageType[]|null
     */
    public function getMarketingMessage()
    {
        return $this->MarketingMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingMessageForArrayConstraintsFromSetMarketingMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseParametersResponseTypeMarketingMessageItem) {
            // validation for constraint: itemType
            if (!$responseParametersResponseTypeMarketingMessageItem instanceof \StructType\MarketingMessageType) {
                $invalidValues[] = is_object($responseParametersResponseTypeMarketingMessageItem) ? get_class($responseParametersResponseTypeMarketingMessageItem) : sprintf('%s(%s)', gettype($responseParametersResponseTypeMarketingMessageItem), var_export($responseParametersResponseTypeMarketingMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingMessage property can only contain items of type \StructType\MarketingMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingMessageType[] $marketingMessage
     * @return \StructType\ResponseParametersResponseType
     */
    public function setMarketingMessage(array $marketingMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingMessageArrayErrorMessage = self::validateMarketingMessageForArrayConstraintsFromSetMarketingMessage($marketingMessage))) {
            throw new \InvalidArgumentException($marketingMessageArrayErrorMessage, __LINE__);
        }
        $this->MarketingMessage = $marketingMessage;
        return $this;
    }
    /**
     * Add item to MarketingMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingMessageType $item
     * @return \StructType\ResponseParametersResponseType
     */
    public function addToMarketingMessage(\StructType\MarketingMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketingMessageType) {
            throw new \InvalidArgumentException(sprintf('The MarketingMessage property can only contain items of type \StructType\MarketingMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingMessage[] = $item;
        return $this;
    }
    /**
     * Get MeasurementSystemCode value
     * @return string|null
     */
    public function getMeasurementSystemCode()
    {
        return $this->MeasurementSystemCode;
    }
    /**
     * Set MeasurementSystemCode value
     * @param string $measurementSystemCode
     * @return \StructType\ResponseParametersResponseType
     */
    public function setMeasurementSystemCode($measurementSystemCode = null)
    {
        // validation for constraint: string
        if (!is_null($measurementSystemCode) && !is_string($measurementSystemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementSystemCode, true), gettype($measurementSystemCode)), __LINE__);
        }
        $this->MeasurementSystemCode = $measurementSystemCode;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\ResponseParametersResponseType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Get PricingParameter value
     * @return \StructType\PricingParameterType|null
     */
    public function getPricingParameter()
    {
        return $this->PricingParameter;
    }
    /**
     * Set PricingParameter value
     * @param \StructType\PricingParameterType $pricingParameter
     * @return \StructType\ResponseParametersResponseType
     */
    public function setPricingParameter(\StructType\PricingParameterType $pricingParameter = null)
    {
        $this->PricingParameter = $pricingParameter;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\ResponseParametersResponseType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseParametersResponseTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$responseParametersResponseTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($responseParametersResponseTypeRemarkItem) ? get_class($responseParametersResponseTypeRemarkItem) : sprintf('%s(%s)', gettype($responseParametersResponseTypeRemarkItem), var_export($responseParametersResponseTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\ResponseParametersResponseType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\ResponseParametersResponseType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
}
