<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReshopPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reshop Price
 * @subpackage Structs
 */
class ReshopPriceType extends AbstractStructBase
{
    /**
     * The PriceAndFareDetails
     * Meta information extracted from the WSDL
     * - documentation: A container for Price and Fare detail information.
     * - choice: PriceAndFareDetails | PriceDifferential
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceAndFareDetailsType
     */
    public $PriceAndFareDetails;
    /**
     * The PriceDifferential
     * Meta information extracted from the WSDL
     * - documentation: For each OfferItem, this function allows the airline to inform the seller about amount differential type if this OfferItem is chosen.
     * - choice: PriceAndFareDetails | PriceDifferential
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceDifferentialType
     */
    public $PriceDifferential;
    /**
     * Constructor method for ReshopPriceType
     * @uses ReshopPriceType::setPriceAndFareDetails()
     * @uses ReshopPriceType::setPriceDifferential()
     * @param \StructType\PriceAndFareDetailsType $priceAndFareDetails
     * @param \StructType\PriceDifferentialType $priceDifferential
     */
    public function __construct(\StructType\PriceAndFareDetailsType $priceAndFareDetails = null, \StructType\PriceDifferentialType $priceDifferential = null)
    {
        $this
            ->setPriceAndFareDetails($priceAndFareDetails)
            ->setPriceDifferential($priceDifferential);
    }
    /**
     * Get PriceAndFareDetails value
     * @return \StructType\PriceAndFareDetailsType
     */
    public function getPriceAndFareDetails()
    {
        return isset($this->PriceAndFareDetails) ? $this->PriceAndFareDetails : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPriceAndFareDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceAndFareDetails method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePriceAndFareDetailsForChoiceConstraintsFromSetPriceAndFareDetails($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PriceDifferential',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PriceAndFareDetails can\'t be set as the property %s is already set. Only one property must be set among these properties: PriceAndFareDetails, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PriceAndFareDetails value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PriceAndFareDetailsType $priceAndFareDetails
     * @return \StructType\ReshopPriceType
     */
    public function setPriceAndFareDetails(\StructType\PriceAndFareDetailsType $priceAndFareDetails = null)
    {
        // validation for constraint: choice(PriceAndFareDetails, PriceDifferential)
        if ('' !== ($priceAndFareDetailsChoiceErrorMessage = self::validatePriceAndFareDetailsForChoiceConstraintsFromSetPriceAndFareDetails($priceAndFareDetails))) {
            throw new \InvalidArgumentException($priceAndFareDetailsChoiceErrorMessage, __LINE__);
        }
        if (is_null($priceAndFareDetails) || (is_array($priceAndFareDetails) && empty($priceAndFareDetails))) {
            unset($this->PriceAndFareDetails);
        } else {
            $this->PriceAndFareDetails = $priceAndFareDetails;
        }
        return $this;
    }
    /**
     * Get PriceDifferential value
     * @return \StructType\PriceDifferentialType
     */
    public function getPriceDifferential()
    {
        return isset($this->PriceDifferential) ? $this->PriceDifferential : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPriceDifferential method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceDifferential method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePriceDifferentialForChoiceConstraintsFromSetPriceDifferential($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PriceAndFareDetails',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PriceDifferential can\'t be set as the property %s is already set. Only one property must be set among these properties: PriceDifferential, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PriceDifferential value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PriceDifferentialType $priceDifferential
     * @return \StructType\ReshopPriceType
     */
    public function setPriceDifferential(\StructType\PriceDifferentialType $priceDifferential = null)
    {
        // validation for constraint: choice(PriceAndFareDetails, PriceDifferential)
        if ('' !== ($priceDifferentialChoiceErrorMessage = self::validatePriceDifferentialForChoiceConstraintsFromSetPriceDifferential($priceDifferential))) {
            throw new \InvalidArgumentException($priceDifferentialChoiceErrorMessage, __LINE__);
        }
        if (is_null($priceDifferential) || (is_array($priceDifferential) && empty($priceDifferential))) {
            unset($this->PriceDifferential);
        } else {
            $this->PriceDifferential = $priceDifferential;
        }
        return $this;
    }
}
