<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReshopOffersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reshopped Carrier Offers.
 * @subpackage Structs
 */
class ReshopOffersType extends AbstractStructBase
{
    /**
     * The ALaCarteOffer
     * Meta information extracted from the WSDL
     * - documentation: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a
     * container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related
     * Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping
     * Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ALaCarteOfferType[]
     */
    public $ALaCarteOffer;
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - documentation: Changed Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
     * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
     * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
     * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangedOfferType[]
     */
    public $Offer;
    /**
     * The RequotedOffer
     * Meta information extracted from the WSDL
     * - documentation: Changed Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
     * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
     * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
     * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChangedOfferType
     */
    public $RequotedOffer;
    /**
     * Constructor method for ReshopOffersType
     * @uses ReshopOffersType::setALaCarteOffer()
     * @uses ReshopOffersType::setOffer()
     * @uses ReshopOffersType::setRequotedOffer()
     * @param \StructType\ALaCarteOfferType[] $aLaCarteOffer
     * @param \StructType\ChangedOfferType[] $offer
     * @param \StructType\ChangedOfferType $requotedOffer
     */
    public function __construct(array $aLaCarteOffer = array(), array $offer = array(), \StructType\ChangedOfferType $requotedOffer = null)
    {
        $this
            ->setALaCarteOffer($aLaCarteOffer)
            ->setOffer($offer)
            ->setRequotedOffer($requotedOffer);
    }
    /**
     * Get ALaCarteOffer value
     * @return \StructType\ALaCarteOfferType[]|null
     */
    public function getALaCarteOffer()
    {
        return $this->ALaCarteOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setALaCarteOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setALaCarteOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateALaCarteOfferForArrayConstraintsFromSetALaCarteOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reshopOffersTypeALaCarteOfferItem) {
            // validation for constraint: itemType
            if (!$reshopOffersTypeALaCarteOfferItem instanceof \StructType\ALaCarteOfferType) {
                $invalidValues[] = is_object($reshopOffersTypeALaCarteOfferItem) ? get_class($reshopOffersTypeALaCarteOfferItem) : sprintf('%s(%s)', gettype($reshopOffersTypeALaCarteOfferItem), var_export($reshopOffersTypeALaCarteOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ALaCarteOffer property can only contain items of type \StructType\ALaCarteOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ALaCarteOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ALaCarteOfferType[] $aLaCarteOffer
     * @return \StructType\ReshopOffersType
     */
    public function setALaCarteOffer(array $aLaCarteOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($aLaCarteOfferArrayErrorMessage = self::validateALaCarteOfferForArrayConstraintsFromSetALaCarteOffer($aLaCarteOffer))) {
            throw new \InvalidArgumentException($aLaCarteOfferArrayErrorMessage, __LINE__);
        }
        $this->ALaCarteOffer = $aLaCarteOffer;
        return $this;
    }
    /**
     * Add item to ALaCarteOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ALaCarteOfferType $item
     * @return \StructType\ReshopOffersType
     */
    public function addToALaCarteOffer(\StructType\ALaCarteOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ALaCarteOfferType) {
            throw new \InvalidArgumentException(sprintf('The ALaCarteOffer property can only contain items of type \StructType\ALaCarteOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ALaCarteOffer[] = $item;
        return $this;
    }
    /**
     * Get Offer value
     * @return \StructType\ChangedOfferType[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reshopOffersTypeOfferItem) {
            // validation for constraint: itemType
            if (!$reshopOffersTypeOfferItem instanceof \StructType\ChangedOfferType) {
                $invalidValues[] = is_object($reshopOffersTypeOfferItem) ? get_class($reshopOffersTypeOfferItem) : sprintf('%s(%s)', gettype($reshopOffersTypeOfferItem), var_export($reshopOffersTypeOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\ChangedOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangedOfferType[] $offer
     * @return \StructType\ReshopOffersType
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangedOfferType $item
     * @return \StructType\ReshopOffersType
     */
    public function addToOffer(\StructType\ChangedOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangedOfferType) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\ChangedOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Get RequotedOffer value
     * @return \StructType\ChangedOfferType|null
     */
    public function getRequotedOffer()
    {
        return $this->RequotedOffer;
    }
    /**
     * Set RequotedOffer value
     * @param \StructType\ChangedOfferType $requotedOffer
     * @return \StructType\ReshopOffersType
     */
    public function setRequotedOffer(\StructType\ChangedOfferType $requotedOffer = null)
    {
        $this->RequotedOffer = $requotedOffer;
        return $this;
    }
}
