<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResChangeInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reservation change information which describes new flight information as it relates to a changed reservation.
 * @subpackage Structs
 */
class ResChangeInfoType extends AbstractStructBase
{
    /**
     * The ResStatusCode
     * Meta information extracted from the WSDL
     * - documentation: This field contains the Reservation Status Code of the 'Reservation Change' flight. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResStatusCode;
    /**
     * The PaxSegmentReferences
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentRefListType
     */
    public $PaxSegmentReferences;
    /**
     * Constructor method for ResChangeInfoType
     * @uses ResChangeInfoType::setResStatusCode()
     * @uses ResChangeInfoType::setPaxSegmentReferences()
     * @param string $resStatusCode
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     */
    public function __construct($resStatusCode = null, \StructType\PaxSegmentRefListType $paxSegmentReferences = null)
    {
        $this
            ->setResStatusCode($resStatusCode)
            ->setPaxSegmentReferences($paxSegmentReferences);
    }
    /**
     * Get ResStatusCode value
     * @return string
     */
    public function getResStatusCode()
    {
        return $this->ResStatusCode;
    }
    /**
     * Set ResStatusCode value
     * @param string $resStatusCode
     * @return \StructType\ResChangeInfoType
     */
    public function setResStatusCode($resStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($resStatusCode) && !is_string($resStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resStatusCode, true), gettype($resStatusCode)), __LINE__);
        }
        $this->ResStatusCode = $resStatusCode;
        return $this;
    }
    /**
     * Get PaxSegmentReferences value
     * @return \StructType\PaxSegmentRefListType|null
     */
    public function getPaxSegmentReferences()
    {
        return $this->PaxSegmentReferences;
    }
    /**
     * Set PaxSegmentReferences value
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     * @return \StructType\ResChangeInfoType
     */
    public function setPaxSegmentReferences(\StructType\PaxSegmentRefListType $paxSegmentReferences = null)
    {
        $this->PaxSegmentReferences = $paxSegmentReferences;
        return $this;
    }
}
