<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains refund type, payment type and amount attributes for a specific product, purpose, or service.
 * @subpackage Structs
 */
class RefundType extends AbstractStructBase
{
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description. Example: 'Full refund within 30 days of departure'. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The FixedAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an exact fixed fee amount relating to this condition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $FixedAmount;
    /**
     * The LevelTypeCode
     * Meta information extracted from the WSDL
     * - documentation: This will identify the type of re fundability for the condition. This will be one of the following. Fully Refundable Partly Refundable Non Refundable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LevelTypeCode;
    /**
     * The MaximumAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an Maximum refund amount which will be applied when a variable fee amount is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MaximumAmount;
    /**
     * The MinimumAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an Minimum refund amount which will be applied when a variable refund amount is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MinimumAmount;
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: This stores a code to represent the form of payment to be used to reimburse the customer/passenger.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Stores a percentage which will be used to determine the refund to be applied in conjunction or not with minimum and maximum amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Percent;
    /**
     * Constructor method for RefundType
     * @uses RefundType::setDescText()
     * @uses RefundType::setFixedAmount()
     * @uses RefundType::setLevelTypeCode()
     * @uses RefundType::setMaximumAmount()
     * @uses RefundType::setMinimumAmount()
     * @uses RefundType::setPaymentTypeCode()
     * @uses RefundType::setPercent()
     * @param string $descText
     * @param \StructType\AmountType $fixedAmount
     * @param string $levelTypeCode
     * @param \StructType\AmountType $maximumAmount
     * @param \StructType\AmountType $minimumAmount
     * @param string $paymentTypeCode
     * @param float $percent
     */
    public function __construct($descText = null, \StructType\AmountType $fixedAmount = null, $levelTypeCode = null, \StructType\AmountType $maximumAmount = null, \StructType\AmountType $minimumAmount = null, $paymentTypeCode = null, $percent = null)
    {
        $this
            ->setDescText($descText)
            ->setFixedAmount($fixedAmount)
            ->setLevelTypeCode($levelTypeCode)
            ->setMaximumAmount($maximumAmount)
            ->setMinimumAmount($minimumAmount)
            ->setPaymentTypeCode($paymentTypeCode)
            ->setPercent($percent);
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\RefundType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get FixedAmount value
     * @return \StructType\AmountType|null
     */
    public function getFixedAmount()
    {
        return $this->FixedAmount;
    }
    /**
     * Set FixedAmount value
     * @param \StructType\AmountType $fixedAmount
     * @return \StructType\RefundType
     */
    public function setFixedAmount(\StructType\AmountType $fixedAmount = null)
    {
        $this->FixedAmount = $fixedAmount;
        return $this;
    }
    /**
     * Get LevelTypeCode value
     * @return string|null
     */
    public function getLevelTypeCode()
    {
        return $this->LevelTypeCode;
    }
    /**
     * Set LevelTypeCode value
     * @uses \EnumType\LevelTypeCode::valueIsValid()
     * @uses \EnumType\LevelTypeCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $levelTypeCode
     * @return \StructType\RefundType
     */
    public function setLevelTypeCode($levelTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LevelTypeCode::valueIsValid($levelTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LevelTypeCode', is_array($levelTypeCode) ? implode(', ', $levelTypeCode) : var_export($levelTypeCode, true), implode(', ', \EnumType\LevelTypeCode::getValidValues())), __LINE__);
        }
        $this->LevelTypeCode = $levelTypeCode;
        return $this;
    }
    /**
     * Get MaximumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMaximumAmount()
    {
        return $this->MaximumAmount;
    }
    /**
     * Set MaximumAmount value
     * @param \StructType\AmountType $maximumAmount
     * @return \StructType\RefundType
     */
    public function setMaximumAmount(\StructType\AmountType $maximumAmount = null)
    {
        $this->MaximumAmount = $maximumAmount;
        return $this;
    }
    /**
     * Get MinimumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMinimumAmount()
    {
        return $this->MinimumAmount;
    }
    /**
     * Set MinimumAmount value
     * @param \StructType\AmountType $minimumAmount
     * @return \StructType\RefundType
     */
    public function setMinimumAmount(\StructType\AmountType $minimumAmount = null)
    {
        $this->MinimumAmount = $minimumAmount;
        return $this;
    }
    /**
     * Get PaymentTypeCode value
     * @return string|null
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\RefundType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\RefundType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
}
