<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundPaymentCardType StructType
 * Meta information extracted from the WSDL
 * - documentation: A specialization of Payment Card used for refund criteria, defined as a device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
 * @subpackage Structs
 */
class RefundPaymentCardType extends AbstractStructBase
{
    /**
     * The CardBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A two-letter code assigned according to IATA Resolution 728. Example: VI for Visa | ENUM to specify the CC vendor code in case FOID is a Credit Card (e.g. VI, MC, etc). | Additional BDT to specify the CC vendor code in case FOID is a
     * Credit Card.
     * - base: CreditCardVendorCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-zA-Z]{1,2}
     * @var string
     */
    public $CardBrandCode;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - documentation: Name of credit card holder. Example: JOHN SMITH | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardIssuingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Payment Card issuing country code. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha
     * Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CardIssuingCountryCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: The card number indicated on the payment card. | Data type for Payment Card Number.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9X]{1,19}
     * @var string
     */
    public $CardNumber;
    /**
     * The CardProductTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardProductTypeCode;
    /**
     * The CardSeqNumber
     * Meta information extracted from the WSDL
     * - documentation: Number displayed on a payment card following the card number which indicates if the card is an original or if it was re-issued with the same card number. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CardSeqNumber;
    /**
     * The CardTypeText
     * Meta information extracted from the WSDL
     * - documentation: Additional description for the magnetic stripe card type (debit card, credit card, prepaid card, etc.) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardTypeText;
    /**
     * The EncryptedData
     * Meta information extracted from the WSDL
     * - documentation: Payment Card details passed onto airline in an encrypted format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptedDataType
     */
    public $EncryptedData;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: The last month of validity Example: 0119 | BDT used to define card issue/expiry dates in a 4N format.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * @var string
     */
    public $ExpirationDate;
    /**
     * The PaymentInstrumentOwnershipCode
     * Meta information extracted from the WSDL
     * - documentation: Owner of the Payment Instrument. For example, Seller would mean the Seller is using their own card, BSP/ARC etc | Ownership Type Code
     * - base: OwnershipTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInstrumentOwnershipCode;
    /**
     * The ProtectedCardID
     * Meta information extracted from the WSDL
     * - documentation: Payment card number protected in a non format preserving fashion. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProtectedCardID;
    /**
     * Constructor method for RefundPaymentCardType
     * @uses RefundPaymentCardType::setCardBrandCode()
     * @uses RefundPaymentCardType::setCardHolderName()
     * @uses RefundPaymentCardType::setCardIssuingCountryCode()
     * @uses RefundPaymentCardType::setCardNumber()
     * @uses RefundPaymentCardType::setCardProductTypeCode()
     * @uses RefundPaymentCardType::setCardSeqNumber()
     * @uses RefundPaymentCardType::setCardTypeText()
     * @uses RefundPaymentCardType::setEncryptedData()
     * @uses RefundPaymentCardType::setExpirationDate()
     * @uses RefundPaymentCardType::setPaymentInstrumentOwnershipCode()
     * @uses RefundPaymentCardType::setProtectedCardID()
     * @param string $cardBrandCode
     * @param string $cardHolderName
     * @param string $cardIssuingCountryCode
     * @param string $cardNumber
     * @param string $cardProductTypeCode
     * @param float $cardSeqNumber
     * @param string $cardTypeText
     * @param \StructType\EncryptedDataType $encryptedData
     * @param string $expirationDate
     * @param string $paymentInstrumentOwnershipCode
     * @param string $protectedCardID
     */
    public function __construct($cardBrandCode = null, $cardHolderName = null, $cardIssuingCountryCode = null, $cardNumber = null, $cardProductTypeCode = null, $cardSeqNumber = null, $cardTypeText = null, \StructType\EncryptedDataType $encryptedData = null, $expirationDate = null, $paymentInstrumentOwnershipCode = null, $protectedCardID = null)
    {
        $this
            ->setCardBrandCode($cardBrandCode)
            ->setCardHolderName($cardHolderName)
            ->setCardIssuingCountryCode($cardIssuingCountryCode)
            ->setCardNumber($cardNumber)
            ->setCardProductTypeCode($cardProductTypeCode)
            ->setCardSeqNumber($cardSeqNumber)
            ->setCardTypeText($cardTypeText)
            ->setEncryptedData($encryptedData)
            ->setExpirationDate($expirationDate)
            ->setPaymentInstrumentOwnershipCode($paymentInstrumentOwnershipCode)
            ->setProtectedCardID($protectedCardID);
    }
    /**
     * Get CardBrandCode value
     * @return string|null
     */
    public function getCardBrandCode()
    {
        return $this->CardBrandCode;
    }
    /**
     * Set CardBrandCode value
     * @param string $cardBrandCode
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardBrandCode($cardBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardBrandCode) && !is_string($cardBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardBrandCode, true), gettype($cardBrandCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,2})
        if (!is_null($cardBrandCode) && !preg_match('/[0-9a-zA-Z]{1,2}/', $cardBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,2}', var_export($cardBrandCode, true)), __LINE__);
        }
        $this->CardBrandCode = $cardBrandCode;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get CardIssuingCountryCode value
     * @return string|null
     */
    public function getCardIssuingCountryCode()
    {
        return $this->CardIssuingCountryCode;
    }
    /**
     * Set CardIssuingCountryCode value
     * @param string $cardIssuingCountryCode
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardIssuingCountryCode($cardIssuingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssuingCountryCode) && !is_string($cardIssuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssuingCountryCode, true), gettype($cardIssuingCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($cardIssuingCountryCode) && !preg_match('/[A-Z]{2}/', $cardIssuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($cardIssuingCountryCode, true)), __LINE__);
        }
        $this->CardIssuingCountryCode = $cardIssuingCountryCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9X]{1,19})
        if (!is_null($cardNumber) && !preg_match('/[0-9X]{1,19}/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9X]{1,19}', var_export($cardNumber, true)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardProductTypeCode value
     * @return string|null
     */
    public function getCardProductTypeCode()
    {
        return $this->CardProductTypeCode;
    }
    /**
     * Set CardProductTypeCode value
     * @param string $cardProductTypeCode
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardProductTypeCode($cardProductTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardProductTypeCode) && !is_string($cardProductTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProductTypeCode, true), gettype($cardProductTypeCode)), __LINE__);
        }
        $this->CardProductTypeCode = $cardProductTypeCode;
        return $this;
    }
    /**
     * Get CardSeqNumber value
     * @return float|null
     */
    public function getCardSeqNumber()
    {
        return $this->CardSeqNumber;
    }
    /**
     * Set CardSeqNumber value
     * @param float $cardSeqNumber
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardSeqNumber($cardSeqNumber = null)
    {
        // validation for constraint: float
        if (!is_null($cardSeqNumber) && !(is_float($cardSeqNumber) || is_numeric($cardSeqNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cardSeqNumber, true), gettype($cardSeqNumber)), __LINE__);
        }
        $this->CardSeqNumber = $cardSeqNumber;
        return $this;
    }
    /**
     * Get CardTypeText value
     * @return string|null
     */
    public function getCardTypeText()
    {
        return $this->CardTypeText;
    }
    /**
     * Set CardTypeText value
     * @param string $cardTypeText
     * @return \StructType\RefundPaymentCardType
     */
    public function setCardTypeText($cardTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeText) && !is_string($cardTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeText, true), gettype($cardTypeText)), __LINE__);
        }
        $this->CardTypeText = $cardTypeText;
        return $this;
    }
    /**
     * Get EncryptedData value
     * @return \StructType\EncryptedDataType|null
     */
    public function getEncryptedData()
    {
        return $this->EncryptedData;
    }
    /**
     * Set EncryptedData value
     * @param \StructType\EncryptedDataType $encryptedData
     * @return \StructType\RefundPaymentCardType
     */
    public function setEncryptedData(\StructType\EncryptedDataType $encryptedData = null)
    {
        $this->EncryptedData = $encryptedData;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\RefundPaymentCardType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($expirationDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($expirationDate, true)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get PaymentInstrumentOwnershipCode value
     * @return string|null
     */
    public function getPaymentInstrumentOwnershipCode()
    {
        return $this->PaymentInstrumentOwnershipCode;
    }
    /**
     * Set PaymentInstrumentOwnershipCode value
     * @param string $paymentInstrumentOwnershipCode
     * @return \StructType\RefundPaymentCardType
     */
    public function setPaymentInstrumentOwnershipCode($paymentInstrumentOwnershipCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstrumentOwnershipCode) && !is_string($paymentInstrumentOwnershipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstrumentOwnershipCode, true), gettype($paymentInstrumentOwnershipCode)), __LINE__);
        }
        $this->PaymentInstrumentOwnershipCode = $paymentInstrumentOwnershipCode;
        return $this;
    }
    /**
     * Get ProtectedCardID value
     * @return string|null
     */
    public function getProtectedCardID()
    {
        return $this->ProtectedCardID;
    }
    /**
     * Set ProtectedCardID value
     * @param string $protectedCardID
     * @return \StructType\RefundPaymentCardType
     */
    public function setProtectedCardID($protectedCardID = null)
    {
        // validation for constraint: string
        if (!is_null($protectedCardID) && !is_string($protectedCardID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protectedCardID, true), gettype($protectedCardID)), __LINE__);
        }
        $this->ProtectedCardID = $protectedCardID;
        return $this;
    }
}
