<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedressCaseType StructType
 * Meta information extracted from the WSDL
 * - documentation: A person's case of being registered with a country's redress program, which can eliminate watch list misidentification and assist in identity verification.
 * @subpackage Structs
 */
class RedressCaseType extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The RedressCaseID
     * Meta information extracted from the WSDL
     * - documentation: A unique government-issued identifier assigned to a redress case. | A unique TSA-issued number that helps eliminate watch list misidentification and verify identity.
     * - base: xs:token
     * - maxLength: 256
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $RedressCaseID;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - documentation: The name of the redress program (e.g. Secure Flight Program). | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * Constructor method for RedressCaseType
     * @uses RedressCaseType::setCountryCode()
     * @uses RedressCaseType::setRedressCaseID()
     * @uses RedressCaseType::setProgramName()
     * @param string $countryCode
     * @param string $redressCaseID
     * @param string $programName
     */
    public function __construct($countryCode = null, $redressCaseID = null, $programName = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setRedressCaseID($redressCaseID)
            ->setProgramName($programName);
    }
    /**
     * Get CountryCode value
     * @return string
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\RedressCaseType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[A-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get RedressCaseID value
     * @return string
     */
    public function getRedressCaseID()
    {
        return $this->RedressCaseID;
    }
    /**
     * Set RedressCaseID value
     * @param string $redressCaseID
     * @return \StructType\RedressCaseType
     */
    public function setRedressCaseID($redressCaseID = null)
    {
        // validation for constraint: string
        if (!is_null($redressCaseID) && !is_string($redressCaseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redressCaseID, true), gettype($redressCaseID)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($redressCaseID) && mb_strlen($redressCaseID) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($redressCaseID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($redressCaseID) && mb_strlen($redressCaseID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($redressCaseID)), __LINE__);
        }
        $this->RedressCaseID = $redressCaseID;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\RedressCaseType
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
}
