<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Redeem StructType
 * Meta information extracted from the WSDL
 * - documentation: Redemption information node per traveler
 * @subpackage Structs
 */
class Redeem extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $PaxRefID;
    /**
     * The DatedMarketingSegmentRefID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentRefID[]
     */
    public $DatedMarketingSegmentRefID;
    /**
     * The CurrencyConversion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyConversion[]
     */
    public $CurrencyConversion;
    /**
     * The RequiredAmount
     * @var \StructType\RequiredAmount
     */
    public $RequiredAmount;
    /**
     * The RedemptionAmountCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RedemptionAmountCalc
     */
    public $RedemptionAmountCalc;
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Offer[]
     */
    public $Offer;
    /**
     * The Slider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Slider
     */
    public $Slider;
    /**
     * The OfferID
     * Meta information extracted from the WSDL
     * - documentation: Solution OfferID
     * @var string
     */
    public $OfferID;
    /**
     * The Program
     * Meta information extracted from the WSDL
     * - documentation: Redemption Program Name Example: Miles
     * @var string
     */
    public $Program;
    /**
     * Constructor method for Redeem
     * @uses Redeem::setPaxRefID()
     * @uses Redeem::setDatedMarketingSegmentRefID()
     * @uses Redeem::setCurrencyConversion()
     * @uses Redeem::setRequiredAmount()
     * @uses Redeem::setRedemptionAmountCalc()
     * @uses Redeem::setOffer()
     * @uses Redeem::setSlider()
     * @uses Redeem::setOfferID()
     * @uses Redeem::setProgram()
     * @param mixed $paxRefID
     * @param \StructType\DatedMarketingSegmentRefID[] $datedMarketingSegmentRefID
     * @param \StructType\CurrencyConversion[] $currencyConversion
     * @param \StructType\RequiredAmount $requiredAmount
     * @param \StructType\RedemptionAmountCalc $redemptionAmountCalc
     * @param \StructType\Offer[] $offer
     * @param \StructType\Slider $slider
     * @param string $offerID
     * @param string $program
     */
    public function __construct($paxRefID = null, array $datedMarketingSegmentRefID = array(), array $currencyConversion = array(), \StructType\RequiredAmount $requiredAmount = null, \StructType\RedemptionAmountCalc $redemptionAmountCalc = null, array $offer = array(), \StructType\Slider $slider = null, $offerID = null, $program = null)
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setDatedMarketingSegmentRefID($datedMarketingSegmentRefID)
            ->setCurrencyConversion($currencyConversion)
            ->setRequiredAmount($requiredAmount)
            ->setRedemptionAmountCalc($redemptionAmountCalc)
            ->setOffer($offer)
            ->setSlider($slider)
            ->setOfferID($offerID)
            ->setProgram($program);
    }
    /**
     * Get PaxRefID value
     * @return mixed|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param mixed $paxRefID
     * @return \StructType\Redeem
     */
    public function setPaxRefID($paxRefID = null)
    {
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentRefID value
     * @return \StructType\DatedMarketingSegmentRefID[]|null
     */
    public function getDatedMarketingSegmentRefID()
    {
        return $this->DatedMarketingSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentRefIDForArrayConstraintsFromSetDatedMarketingSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $redeemDatedMarketingSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!$redeemDatedMarketingSegmentRefIDItem instanceof \StructType\DatedMarketingSegmentRefID) {
                $invalidValues[] = is_object($redeemDatedMarketingSegmentRefIDItem) ? get_class($redeemDatedMarketingSegmentRefIDItem) : sprintf('%s(%s)', gettype($redeemDatedMarketingSegmentRefIDItem), var_export($redeemDatedMarketingSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegmentRefID property can only contain items of type \StructType\DatedMarketingSegmentRefID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedMarketingSegmentRefID value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentRefID[] $datedMarketingSegmentRefID
     * @return \StructType\Redeem
     */
    public function setDatedMarketingSegmentRefID(array $datedMarketingSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentRefIDArrayErrorMessage = self::validateDatedMarketingSegmentRefIDForArrayConstraintsFromSetDatedMarketingSegmentRefID($datedMarketingSegmentRefID))) {
            throw new \InvalidArgumentException($datedMarketingSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegmentRefID = $datedMarketingSegmentRefID;
        return $this;
    }
    /**
     * Add item to DatedMarketingSegmentRefID value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentRefID $item
     * @return \StructType\Redeem
     */
    public function addToDatedMarketingSegmentRefID(\StructType\DatedMarketingSegmentRefID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedMarketingSegmentRefID) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegmentRefID property can only contain items of type \StructType\DatedMarketingSegmentRefID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedMarketingSegmentRefID[] = $item;
        return $this;
    }
    /**
     * Get CurrencyConversion value
     * @return \StructType\CurrencyConversion[]|null
     */
    public function getCurrencyConversion()
    {
        return $this->CurrencyConversion;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrencyConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrencyConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyConversionForArrayConstraintsFromSetCurrencyConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $redeemCurrencyConversionItem) {
            // validation for constraint: itemType
            if (!$redeemCurrencyConversionItem instanceof \StructType\CurrencyConversion) {
                $invalidValues[] = is_object($redeemCurrencyConversionItem) ? get_class($redeemCurrencyConversionItem) : sprintf('%s(%s)', gettype($redeemCurrencyConversionItem), var_export($redeemCurrencyConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurrencyConversion property can only contain items of type \StructType\CurrencyConversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurrencyConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyConversion[] $currencyConversion
     * @return \StructType\Redeem
     */
    public function setCurrencyConversion(array $currencyConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyConversionArrayErrorMessage = self::validateCurrencyConversionForArrayConstraintsFromSetCurrencyConversion($currencyConversion))) {
            throw new \InvalidArgumentException($currencyConversionArrayErrorMessage, __LINE__);
        }
        $this->CurrencyConversion = $currencyConversion;
        return $this;
    }
    /**
     * Add item to CurrencyConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyConversion $item
     * @return \StructType\Redeem
     */
    public function addToCurrencyConversion(\StructType\CurrencyConversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyConversion) {
            throw new \InvalidArgumentException(sprintf('The CurrencyConversion property can only contain items of type \StructType\CurrencyConversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurrencyConversion[] = $item;
        return $this;
    }
    /**
     * Get RequiredAmount value
     * @return \StructType\RequiredAmount|null
     */
    public function getRequiredAmount()
    {
        return $this->RequiredAmount;
    }
    /**
     * Set RequiredAmount value
     * @param \StructType\RequiredAmount $requiredAmount
     * @return \StructType\Redeem
     */
    public function setRequiredAmount(\StructType\RequiredAmount $requiredAmount = null)
    {
        $this->RequiredAmount = $requiredAmount;
        return $this;
    }
    /**
     * Get RedemptionAmountCalc value
     * @return \StructType\RedemptionAmountCalc|null
     */
    public function getRedemptionAmountCalc()
    {
        return $this->RedemptionAmountCalc;
    }
    /**
     * Set RedemptionAmountCalc value
     * @param \StructType\RedemptionAmountCalc $redemptionAmountCalc
     * @return \StructType\Redeem
     */
    public function setRedemptionAmountCalc(\StructType\RedemptionAmountCalc $redemptionAmountCalc = null)
    {
        $this->RedemptionAmountCalc = $redemptionAmountCalc;
        return $this;
    }
    /**
     * Get Offer value
     * @return \StructType\Offer[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $redeemOfferItem) {
            // validation for constraint: itemType
            if (!$redeemOfferItem instanceof \StructType\Offer) {
                $invalidValues[] = is_object($redeemOfferItem) ? get_class($redeemOfferItem) : sprintf('%s(%s)', gettype($redeemOfferItem), var_export($redeemOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer[] $offer
     * @return \StructType\Redeem
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\Offer $item
     * @return \StructType\Redeem
     */
    public function addToOffer(\StructType\Offer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Offer) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\Offer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
    /**
     * Get Slider value
     * @return \StructType\Slider|null
     */
    public function getSlider()
    {
        return $this->Slider;
    }
    /**
     * Set Slider value
     * @param \StructType\Slider $slider
     * @return \StructType\Redeem
     */
    public function setSlider(\StructType\Slider $slider = null)
    {
        $this->Slider = $slider;
        return $this;
    }
    /**
     * Get OfferID value
     * @return string|null
     */
    public function getOfferID()
    {
        return $this->OfferID;
    }
    /**
     * Set OfferID value
     * @param string $offerID
     * @return \StructType\Redeem
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerID, true), gettype($offerID)), __LINE__);
        }
        $this->OfferID = $offerID;
        return $this;
    }
    /**
     * Get Program value
     * @return string|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param string $program
     * @return \StructType\Redeem
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($program, true), gettype($program)), __LINE__);
        }
        $this->Program = $program;
        return $this;
    }
}
