<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
 * @subpackage Structs
 */
class PromotionType extends AbstractStructBase
{
    /**
     * The PromotionID
     * Meta information extracted from the WSDL
     * - documentation: Promotion code ID or number. Example: PROMO123. Used in conjunction with Link (Promotion URL), Issuer (Promotion Owner or Sponsor) and Remarks (Promotion remarks). | An identifier is a character string used to uniquely identify one
     * instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PromotionID;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Individual to which this Promotion applies. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerName;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PromotionIssuer
     * Meta information extracted from the WSDL
     * - documentation: Promotion Issuer or Sponsor
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PromotionIssuerType
     */
    public $PromotionIssuer;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Promotion URL. Example: http://promos.site.com | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web, using
     * specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for PromotionType
     * @uses PromotionType::setPromotionID()
     * @uses PromotionType::setOwnerName()
     * @uses PromotionType::setPaxRefID()
     * @uses PromotionType::setPromotionIssuer()
     * @uses PromotionType::setRemark()
     * @uses PromotionType::setURL()
     * @param string $promotionID
     * @param string $ownerName
     * @param string[] $paxRefID
     * @param \StructType\PromotionIssuerType $promotionIssuer
     * @param \StructType\RemarkType[] $remark
     * @param string $uRL
     */
    public function __construct($promotionID = null, $ownerName = null, array $paxRefID = array(), \StructType\PromotionIssuerType $promotionIssuer = null, array $remark = array(), $uRL = null)
    {
        $this
            ->setPromotionID($promotionID)
            ->setOwnerName($ownerName)
            ->setPaxRefID($paxRefID)
            ->setPromotionIssuer($promotionIssuer)
            ->setRemark($remark)
            ->setURL($uRL);
    }
    /**
     * Get PromotionID value
     * @return string
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param string $promotionID
     * @return \StructType\PromotionType
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: string
        if (!is_null($promotionID) && !is_string($promotionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionID, true), gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get OwnerName value
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->OwnerName;
    }
    /**
     * Set OwnerName value
     * @param string $ownerName
     * @return \StructType\PromotionType
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ownerName) && mb_strlen($ownerName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ownerName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ownerName) && mb_strlen($ownerName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ownerName)), __LINE__);
        }
        $this->OwnerName = $ownerName;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($promotionTypePaxRefIDItem)) {
                $invalidValues[] = is_object($promotionTypePaxRefIDItem) ? get_class($promotionTypePaxRefIDItem) : sprintf('%s(%s)', gettype($promotionTypePaxRefIDItem), var_export($promotionTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\PromotionType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PromotionType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PromotionIssuer value
     * @return \StructType\PromotionIssuerType|null
     */
    public function getPromotionIssuer()
    {
        return $this->PromotionIssuer;
    }
    /**
     * Set PromotionIssuer value
     * @param \StructType\PromotionIssuerType $promotionIssuer
     * @return \StructType\PromotionType
     */
    public function setPromotionIssuer(\StructType\PromotionIssuerType $promotionIssuer = null)
    {
        $this->PromotionIssuer = $promotionIssuer;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$promotionTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($promotionTypeRemarkItem) ? get_class($promotionTypeRemarkItem) : sprintf('%s(%s)', gettype($promotionTypeRemarkItem), var_export($promotionTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\PromotionType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\PromotionType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\PromotionType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
