<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to publicizing a product, organization, or venture so as to increase sales or public awareness.
 * @subpackage Structs
 */
class PromotionListType extends AbstractStructBase
{
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PromotionType[]
     */
    public $Promotion;
    /**
     * Constructor method for PromotionListType
     * @uses PromotionListType::setPromotion()
     * @param \StructType\PromotionType[] $promotion
     */
    public function __construct(array $promotion = array())
    {
        $this
            ->setPromotion($promotion);
    }
    /**
     * Get Promotion value
     * @return \StructType\PromotionType[]
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionListTypePromotionItem) {
            // validation for constraint: itemType
            if (!$promotionListTypePromotionItem instanceof \StructType\PromotionType) {
                $invalidValues[] = is_object($promotionListTypePromotionItem) ? get_class($promotionListTypePromotionItem) : sprintf('%s(%s)', gettype($promotionListTypePromotionItem), var_export($promotionListTypePromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType[] $promotion
     * @return \StructType\PromotionListType
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType $item
     * @return \StructType\PromotionListType
     */
    public function addToPromotion(\StructType\PromotionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionType) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
}
