<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceGroup StructType
 * Meta information extracted from the WSDL
 * - documentation: List of prices offered for this OD and flight component, e.g. 3 PriceClasses are offered:Tango - $200.00Tango Plus - 300.00Executive - 450.00
 * @subpackage Structs
 */
class PriceGroup extends AbstractStructBase
{
    /**
     * The PriceClass
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: PriceClass
     * @var \StructType\PriceClass[]
     */
    public $PriceClass;
    /**
     * Constructor method for PriceGroup
     * @uses PriceGroup::setPriceClass()
     * @param \StructType\PriceClass[] $priceClass
     */
    public function __construct(array $priceClass = array())
    {
        $this
            ->setPriceClass($priceClass);
    }
    /**
     * Get PriceClass value
     * @return \StructType\PriceClass[]|null
     */
    public function getPriceClass()
    {
        return $this->PriceClass;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceClassForArrayConstraintsFromSetPriceClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceGroupPriceClassItem) {
            // validation for constraint: itemType
            if (!$priceGroupPriceClassItem instanceof \StructType\PriceClass) {
                $invalidValues[] = is_object($priceGroupPriceClassItem) ? get_class($priceGroupPriceClassItem) : sprintf('%s(%s)', gettype($priceGroupPriceClassItem), var_export($priceGroupPriceClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceClass property can only contain items of type \StructType\PriceClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceClass value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceClass[] $priceClass
     * @return \StructType\PriceGroup
     */
    public function setPriceClass(array $priceClass = array())
    {
        // validation for constraint: array
        if ('' !== ($priceClassArrayErrorMessage = self::validatePriceClassForArrayConstraintsFromSetPriceClass($priceClass))) {
            throw new \InvalidArgumentException($priceClassArrayErrorMessage, __LINE__);
        }
        $this->PriceClass = $priceClass;
        return $this;
    }
    /**
     * Add item to PriceClass value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceClass $item
     * @return \StructType\PriceGroup
     */
    public function addToPriceClass(\StructType\PriceClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceClass) {
            throw new \InvalidArgumentException(sprintf('The PriceClass property can only contain items of type \StructType\PriceClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PriceClass[] = $item;
        return $this;
    }
}
