<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceDifferentialType StructType
 * Meta information extracted from the WSDL
 * - documentation: For each OfferItem, this function allows the airline to inform the seller about amount differential type if this OfferItem is chosen.
 * @subpackage Structs
 */
class PriceDifferentialType extends AbstractStructBase
{
    /**
     * The DifferentialTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Several types of action are possible when the customer selects a reshopped offer-
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DifferentialTypeCode;
    /**
     * The DiffPrice
     * Meta information extracted from the WSDL
     * - documentation: A specialization of a container for Price and Fare detail information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DiffPrice
     */
    public $DiffPrice;
    /**
     * The NewPrice
     * Meta information extracted from the WSDL
     * - documentation: A container for Price and Fare detail information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NewPrice
     */
    public $NewPrice;
    /**
     * The OldPrice
     * Meta information extracted from the WSDL
     * - documentation: A container for Price and Fare detail information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OldPrice
     */
    public $OldPrice;
    /**
     * Constructor method for PriceDifferentialType
     * @uses PriceDifferentialType::setDifferentialTypeCode()
     * @uses PriceDifferentialType::setDiffPrice()
     * @uses PriceDifferentialType::setNewPrice()
     * @uses PriceDifferentialType::setOldPrice()
     * @param string $differentialTypeCode
     * @param \StructType\DiffPrice $diffPrice
     * @param \StructType\NewPrice $newPrice
     * @param \StructType\OldPrice $oldPrice
     */
    public function __construct($differentialTypeCode = null, \StructType\DiffPrice $diffPrice = null, \StructType\NewPrice $newPrice = null, \StructType\OldPrice $oldPrice = null)
    {
        $this
            ->setDifferentialTypeCode($differentialTypeCode)
            ->setDiffPrice($diffPrice)
            ->setNewPrice($newPrice)
            ->setOldPrice($oldPrice);
    }
    /**
     * Get DifferentialTypeCode value
     * @return string
     */
    public function getDifferentialTypeCode()
    {
        return $this->DifferentialTypeCode;
    }
    /**
     * Set DifferentialTypeCode value
     * @uses \EnumType\DifferentialTypeCode::valueIsValid()
     * @uses \EnumType\DifferentialTypeCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $differentialTypeCode
     * @return \StructType\PriceDifferentialType
     */
    public function setDifferentialTypeCode($differentialTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DifferentialTypeCode::valueIsValid($differentialTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DifferentialTypeCode', is_array($differentialTypeCode) ? implode(', ', $differentialTypeCode) : var_export($differentialTypeCode, true), implode(', ', \EnumType\DifferentialTypeCode::getValidValues())), __LINE__);
        }
        $this->DifferentialTypeCode = $differentialTypeCode;
        return $this;
    }
    /**
     * Get DiffPrice value
     * @return \StructType\DiffPrice
     */
    public function getDiffPrice()
    {
        return $this->DiffPrice;
    }
    /**
     * Set DiffPrice value
     * @param \StructType\DiffPrice $diffPrice
     * @return \StructType\PriceDifferentialType
     */
    public function setDiffPrice(\StructType\DiffPrice $diffPrice = null)
    {
        $this->DiffPrice = $diffPrice;
        return $this;
    }
    /**
     * Get NewPrice value
     * @return \StructType\NewPrice
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param \StructType\NewPrice $newPrice
     * @return \StructType\PriceDifferentialType
     */
    public function setNewPrice(\StructType\NewPrice $newPrice = null)
    {
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get OldPrice value
     * @return \StructType\OldPrice|null
     */
    public function getOldPrice()
    {
        return $this->OldPrice;
    }
    /**
     * Set OldPrice value
     * @param \StructType\OldPrice $oldPrice
     * @return \StructType\PriceDifferentialType
     */
    public function setOldPrice(\StructType\OldPrice $oldPrice = null)
    {
        $this->OldPrice = $oldPrice;
        return $this;
    }
}
