<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceClassType StructType
 * Meta information extracted from the WSDL
 * - documentation: A price point within a particular Cabin Type (sometimes referred to as 'Fare Families').
 * @subpackage Structs
 */
class PriceClassType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Price class name. Example: SUPERSAVER | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The PriceClassID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Price Class within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PriceClassID;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CabinTypeType[]
     */
    public $CabinType;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Price class code. Example: 1, ABC | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The DisplayOrderText
     * Meta information extracted from the WSDL
     * - documentation: The Airline requested default display order (in a client application) for this price class. For example: 2. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayOrderText;
    /**
     * The FareBasisAppText
     * Meta information extracted from the WSDL
     * - documentation: Fare basis application. Examples: Requested, Ticketed, Other. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisAppText;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCode;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * Constructor method for PriceClassType
     * @uses PriceClassType::setName()
     * @uses PriceClassType::setPriceClassID()
     * @uses PriceClassType::setCabinType()
     * @uses PriceClassType::setCode()
     * @uses PriceClassType::setDesc()
     * @uses PriceClassType::setDisplayOrderText()
     * @uses PriceClassType::setFareBasisAppText()
     * @uses PriceClassType::setFareBasisCode()
     * @uses PriceClassType::setRichMedia()
     * @param string $name
     * @param string $priceClassID
     * @param \StructType\CabinTypeType[] $cabinType
     * @param string $code
     * @param \StructType\DescType[] $desc
     * @param string $displayOrderText
     * @param string $fareBasisAppText
     * @param string $fareBasisCode
     * @param \StructType\MediaResourceRefType[] $richMedia
     */
    public function __construct($name = null, $priceClassID = null, array $cabinType = array(), $code = null, array $desc = array(), $displayOrderText = null, $fareBasisAppText = null, $fareBasisCode = null, array $richMedia = array())
    {
        $this
            ->setName($name)
            ->setPriceClassID($priceClassID)
            ->setCabinType($cabinType)
            ->setCode($code)
            ->setDesc($desc)
            ->setDisplayOrderText($displayOrderText)
            ->setFareBasisAppText($fareBasisAppText)
            ->setFareBasisCode($fareBasisCode)
            ->setRichMedia($richMedia);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PriceClassType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PriceClassID value
     * @return string
     */
    public function getPriceClassID()
    {
        return $this->PriceClassID;
    }
    /**
     * Set PriceClassID value
     * @param string $priceClassID
     * @return \StructType\PriceClassType
     */
    public function setPriceClassID($priceClassID = null)
    {
        // validation for constraint: string
        if (!is_null($priceClassID) && !is_string($priceClassID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceClassID, true), gettype($priceClassID)), __LINE__);
        }
        $this->PriceClassID = $priceClassID;
        return $this;
    }
    /**
     * Get CabinType value
     * @return \StructType\CabinTypeType[]|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinTypeForArrayConstraintsFromSetCabinType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceClassTypeCabinTypeItem) {
            // validation for constraint: itemType
            if (!$priceClassTypeCabinTypeItem instanceof \StructType\CabinTypeType) {
                $invalidValues[] = is_object($priceClassTypeCabinTypeItem) ? get_class($priceClassTypeCabinTypeItem) : sprintf('%s(%s)', gettype($priceClassTypeCabinTypeItem), var_export($priceClassTypeCabinTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinType property can only contain items of type \StructType\CabinTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeType[] $cabinType
     * @return \StructType\PriceClassType
     */
    public function setCabinType(array $cabinType = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinTypeArrayErrorMessage = self::validateCabinTypeForArrayConstraintsFromSetCabinType($cabinType))) {
            throw new \InvalidArgumentException($cabinTypeArrayErrorMessage, __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Add item to CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeType $item
     * @return \StructType\PriceClassType
     */
    public function addToCabinType(\StructType\CabinTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinTypeType) {
            throw new \InvalidArgumentException(sprintf('The CabinType property can only contain items of type \StructType\CabinTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinType[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\PriceClassType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceClassTypeDescItem) {
            // validation for constraint: itemType
            if (!$priceClassTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($priceClassTypeDescItem) ? get_class($priceClassTypeDescItem) : sprintf('%s(%s)', gettype($priceClassTypeDescItem), var_export($priceClassTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\PriceClassType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\PriceClassType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get DisplayOrderText value
     * @return string|null
     */
    public function getDisplayOrderText()
    {
        return $this->DisplayOrderText;
    }
    /**
     * Set DisplayOrderText value
     * @param string $displayOrderText
     * @return \StructType\PriceClassType
     */
    public function setDisplayOrderText($displayOrderText = null)
    {
        // validation for constraint: string
        if (!is_null($displayOrderText) && !is_string($displayOrderText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayOrderText, true), gettype($displayOrderText)), __LINE__);
        }
        $this->DisplayOrderText = $displayOrderText;
        return $this;
    }
    /**
     * Get FareBasisAppText value
     * @return string|null
     */
    public function getFareBasisAppText()
    {
        return $this->FareBasisAppText;
    }
    /**
     * Set FareBasisAppText value
     * @param string $fareBasisAppText
     * @return \StructType\PriceClassType
     */
    public function setFareBasisAppText($fareBasisAppText = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisAppText) && !is_string($fareBasisAppText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisAppText, true), gettype($fareBasisAppText)), __LINE__);
        }
        $this->FareBasisAppText = $fareBasisAppText;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\PriceClassType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceClassTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$priceClassTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($priceClassTypeRichMediaItem) ? get_class($priceClassTypeRichMediaItem) : sprintf('%s(%s)', gettype($priceClassTypeRichMediaItem), var_export($priceClassTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\PriceClassType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\PriceClassType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
}
