<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceClass StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the price group associated to this price, e.g. TANGO
 * @subpackage Structs
 */
class PriceClass extends AbstractStructBase
{
    /**
     * The ClassOfService
     * Meta information extracted from the WSDL
     * - documentation: some carriers have an actual ClassofService linked to a PriceClass.Sample: T
     * - use: required
     * @var string
     */
    public $ClassOfService;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Price[]
     */
    public $Price;
    /**
     * The FareRefKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: FareRefKey
     * @var string
     */
    public $FareRefKey;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: FareBasisCode
     * @var string
     */
    public $FareBasisCode;
    /**
     * The ExchangeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ExchangeInfo
     * @var \StructType\ExchangeInfo
     */
    public $ExchangeInfo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: references to the respective PriceClass as defind in the 'PriceClassComments' element.Sample: TANGO
     * @var string
     */
    public $Name;
    /**
     * Constructor method for PriceClass
     * @uses PriceClass::setClassOfService()
     * @uses PriceClass::setPrice()
     * @uses PriceClass::setFareRefKey()
     * @uses PriceClass::setFareBasisCode()
     * @uses PriceClass::setExchangeInfo()
     * @uses PriceClass::setName()
     * @param string $classOfService
     * @param \StructType\Price[] $price
     * @param string $fareRefKey
     * @param string $fareBasisCode
     * @param \StructType\ExchangeInfo $exchangeInfo
     * @param string $name
     */
    public function __construct($classOfService = null, array $price = array(), $fareRefKey = null, $fareBasisCode = null, \StructType\ExchangeInfo $exchangeInfo = null, $name = null)
    {
        $this
            ->setClassOfService($classOfService)
            ->setPrice($price)
            ->setFareRefKey($fareRefKey)
            ->setFareBasisCode($fareBasisCode)
            ->setExchangeInfo($exchangeInfo)
            ->setName($name);
    }
    /**
     * Get ClassOfService value
     * @return string
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \StructType\PriceClass
     */
    public function setClassOfService($classOfService = null)
    {
        // validation for constraint: string
        if (!is_null($classOfService) && !is_string($classOfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classOfService, true), gettype($classOfService)), __LINE__);
        }
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\Price[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceClassPriceItem) {
            // validation for constraint: itemType
            if (!$priceClassPriceItem instanceof \StructType\Price) {
                $invalidValues[] = is_object($priceClassPriceItem) ? get_class($priceClassPriceItem) : sprintf('%s(%s)', gettype($priceClassPriceItem), var_export($priceClassPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\Price, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price[] $price
     * @return \StructType\PriceClass
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price $item
     * @return \StructType\PriceClass
     */
    public function addToPrice(\StructType\Price $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Price) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\Price, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get FareRefKey value
     * @return string|null
     */
    public function getFareRefKey()
    {
        return $this->FareRefKey;
    }
    /**
     * Set FareRefKey value
     * @param string $fareRefKey
     * @return \StructType\PriceClass
     */
    public function setFareRefKey($fareRefKey = null)
    {
        // validation for constraint: string
        if (!is_null($fareRefKey) && !is_string($fareRefKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRefKey, true), gettype($fareRefKey)), __LINE__);
        }
        $this->FareRefKey = $fareRefKey;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\PriceClass
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get ExchangeInfo value
     * @return \StructType\ExchangeInfo|null
     */
    public function getExchangeInfo()
    {
        return $this->ExchangeInfo;
    }
    /**
     * Set ExchangeInfo value
     * @param \StructType\ExchangeInfo $exchangeInfo
     * @return \StructType\PriceClass
     */
    public function setExchangeInfo(\StructType\ExchangeInfo $exchangeInfo = null)
    {
        $this->ExchangeInfo = $exchangeInfo;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PriceClass
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
