<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceCalendarDateType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Price Calendar Date
 * @subpackage Structs
 */
class PriceCalendarDateType extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: A date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The OriginDestRefID
     * Meta information extracted from the WSDL
     * - documentation: Association to one Origin/Destination instance. Example: od1 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginDestRefID;
    /**
     * Constructor method for PriceCalendarDateType
     * @uses PriceCalendarDateType::setDate()
     * @uses PriceCalendarDateType::setOriginDestRefID()
     * @param string $date
     * @param string $originDestRefID
     */
    public function __construct($date = null, $originDestRefID = null)
    {
        $this
            ->setDate($date)
            ->setOriginDestRefID($originDestRefID);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\PriceCalendarDateType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get OriginDestRefID value
     * @return string|null
     */
    public function getOriginDestRefID()
    {
        return $this->OriginDestRefID;
    }
    /**
     * Set OriginDestRefID value
     * @param string $originDestRefID
     * @return \StructType\PriceCalendarDateType
     */
    public function setOriginDestRefID($originDestRefID = null)
    {
        // validation for constraint: string
        if (!is_null($originDestRefID) && !is_string($originDestRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDestRefID, true), gettype($originDestRefID)), __LINE__);
        }
        $this->OriginDestRefID = $originDestRefID;
        return $this;
    }
}
