<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Price StructType
 * Meta information extracted from the WSDL
 * - documentation: Price group
 * @subpackage Structs
 */
class Price extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: Total Fare amount for one traveler of the specified passenger type. Total price = base fare amount + taxes amount. Example: 230000
     * - use: required
     * @var int
     */
    public $Total;
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - base: BaseFareType
     * @var \StructType\BaseFare
     */
    public $BaseFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - ref: Taxes
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The TypeRequested
     * @var string
     */
    public $TypeRequested;
    /**
     * The TypePriced
     * Meta information extracted from the WSDL
     * - documentation: Passenger type being priced. This type can be different from the type requested if there is no available fare for the requested type. For example the requested type is GOV and the priced type is ADT because there is no available fare
     * for type GOV and there is an available fare for type ADT. If the passenger type sent by the GDS is not the below predefined list, then it is shown as is. Predefined values are:ADT= AdultCHD = ChildINF = InfantGOV = GovernmentMIL = MilitarySRC =
     * Senior citizenSTD = StudentYTH = Youth Example: ADT
     * - type: xs:string
     * @var string
     */
    public $TypePriced;
    /**
     * Constructor method for Price
     * @uses Price::setTotal()
     * @uses Price::setBaseFare()
     * @uses Price::setTaxes()
     * @uses Price::setTypeRequested()
     * @uses Price::setTypePriced()
     * @param int $total
     * @param \StructType\BaseFare $baseFare
     * @param \StructType\Taxes $taxes
     * @param string $typeRequested
     * @param string $typePriced
     */
    public function __construct($total = null, \StructType\BaseFare $baseFare = null, \StructType\Taxes $taxes = null, $typeRequested = null, $typePriced = null)
    {
        $this
            ->setTotal($total)
            ->setBaseFare($baseFare)
            ->setTaxes($taxes)
            ->setTypeRequested($typeRequested)
            ->setTypePriced($typePriced);
    }
    /**
     * Get Total value
     * @return int
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\Price
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \StructType\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \StructType\BaseFare $baseFare
     * @return \StructType\Price
     */
    public function setBaseFare(\StructType\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\Price
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TypeRequested value
     * @return string|null
     */
    public function getTypeRequested()
    {
        return $this->TypeRequested;
    }
    /**
     * Set TypeRequested value
     * @param string $typeRequested
     * @return \StructType\Price
     */
    public function setTypeRequested($typeRequested = null)
    {
        // validation for constraint: string
        if (!is_null($typeRequested) && !is_string($typeRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeRequested, true), gettype($typeRequested)), __LINE__);
        }
        $this->TypeRequested = $typeRequested;
        return $this;
    }
    /**
     * Get TypePriced value
     * @return string|null
     */
    public function getTypePriced()
    {
        return $this->TypePriced;
    }
    /**
     * Set TypePriced value
     * @param string $typePriced
     * @return \StructType\Price
     */
    public function setTypePriced($typePriced = null)
    {
        // validation for constraint: string
        if (!is_null($typePriced) && !is_string($typePriced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typePriced, true), gettype($typePriced)), __LINE__);
        }
        $this->TypePriced = $typePriced;
        return $this;
    }
}
