<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position StructType
 * @subpackage Structs
 */
class Position extends AbstractStructBase
{
    /**
     * The _
     * @var int
     */
    public $_;
    /**
     * The RedeemUnits
     * Meta information extracted from the WSDL
     * - documentation: Specifies the amount of redemption miles
     * @var float
     */
    public $RedeemUnits;
    /**
     * The Cash
     * Meta information extracted from the WSDL
     * - documentation: Specifies cash amount equivalent to redemption miles
     * @var float
     */
    public $Cash;
    /**
     * The LeftoverCash
     * Meta information extracted from the WSDL
     * - documentation: Specifies the amount of leftover cash to pay for fare or service after miles are redeemed
     * @var float
     */
    public $LeftoverCash;
    /**
     * The FiledCash
     * Meta information extracted from the WSDL
     * - documentation: Cash amount in filed currency
     * @var float
     */
    public $FiledCash;
    /**
     * The FiledLeftoverCash
     * Meta information extracted from the WSDL
     * - documentation: Leftover cash amount in filed currency
     * @var float
     */
    public $FiledLeftoverCash;
    /**
     * The ConversionRate
     * Meta information extracted from the WSDL
     * - documentation: Specifies the conversion rate for miles to cash
     * @var float
     */
    public $ConversionRate;
    /**
     * Constructor method for Position
     * @uses Position::set_()
     * @uses Position::setRedeemUnits()
     * @uses Position::setCash()
     * @uses Position::setLeftoverCash()
     * @uses Position::setFiledCash()
     * @uses Position::setFiledLeftoverCash()
     * @uses Position::setConversionRate()
     * @param int $_
     * @param float $redeemUnits
     * @param float $cash
     * @param float $leftoverCash
     * @param float $filedCash
     * @param float $filedLeftoverCash
     * @param float $conversionRate
     */
    public function __construct($_ = null, $redeemUnits = null, $cash = null, $leftoverCash = null, $filedCash = null, $filedLeftoverCash = null, $conversionRate = null)
    {
        $this
            ->set_($_)
            ->setRedeemUnits($redeemUnits)
            ->setCash($cash)
            ->setLeftoverCash($leftoverCash)
            ->setFiledCash($filedCash)
            ->setFiledLeftoverCash($filedLeftoverCash)
            ->setConversionRate($conversionRate);
    }
    /**
     * Get _ value
     * @return int|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param int $_
     * @return \StructType\Position
     */
    public function set_($_ = null)
    {
        // validation for constraint: int
        if (!is_null($_) && !(is_int($_) || ctype_digit($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RedeemUnits value
     * @return float|null
     */
    public function getRedeemUnits()
    {
        return $this->RedeemUnits;
    }
    /**
     * Set RedeemUnits value
     * @param float $redeemUnits
     * @return \StructType\Position
     */
    public function setRedeemUnits($redeemUnits = null)
    {
        // validation for constraint: float
        if (!is_null($redeemUnits) && !(is_float($redeemUnits) || is_numeric($redeemUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redeemUnits, true), gettype($redeemUnits)), __LINE__);
        }
        $this->RedeemUnits = $redeemUnits;
        return $this;
    }
    /**
     * Get Cash value
     * @return float|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param float $cash
     * @return \StructType\Position
     */
    public function setCash($cash = null)
    {
        // validation for constraint: float
        if (!is_null($cash) && !(is_float($cash) || is_numeric($cash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash, true), gettype($cash)), __LINE__);
        }
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get LeftoverCash value
     * @return float|null
     */
    public function getLeftoverCash()
    {
        return $this->LeftoverCash;
    }
    /**
     * Set LeftoverCash value
     * @param float $leftoverCash
     * @return \StructType\Position
     */
    public function setLeftoverCash($leftoverCash = null)
    {
        // validation for constraint: float
        if (!is_null($leftoverCash) && !(is_float($leftoverCash) || is_numeric($leftoverCash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($leftoverCash, true), gettype($leftoverCash)), __LINE__);
        }
        $this->LeftoverCash = $leftoverCash;
        return $this;
    }
    /**
     * Get FiledCash value
     * @return float|null
     */
    public function getFiledCash()
    {
        return $this->FiledCash;
    }
    /**
     * Set FiledCash value
     * @param float $filedCash
     * @return \StructType\Position
     */
    public function setFiledCash($filedCash = null)
    {
        // validation for constraint: float
        if (!is_null($filedCash) && !(is_float($filedCash) || is_numeric($filedCash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($filedCash, true), gettype($filedCash)), __LINE__);
        }
        $this->FiledCash = $filedCash;
        return $this;
    }
    /**
     * Get FiledLeftoverCash value
     * @return float|null
     */
    public function getFiledLeftoverCash()
    {
        return $this->FiledLeftoverCash;
    }
    /**
     * Set FiledLeftoverCash value
     * @param float $filedLeftoverCash
     * @return \StructType\Position
     */
    public function setFiledLeftoverCash($filedLeftoverCash = null)
    {
        // validation for constraint: float
        if (!is_null($filedLeftoverCash) && !(is_float($filedLeftoverCash) || is_numeric($filedLeftoverCash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($filedLeftoverCash, true), gettype($filedLeftoverCash)), __LINE__);
        }
        $this->FiledLeftoverCash = $filedLeftoverCash;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return float|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param float $conversionRate
     * @return \StructType\Position
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: float
        if (!is_null($conversionRate) && !(is_float($conversionRate) || is_numeric($conversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
}
