<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Message policy information, including PCI, PII information.
 * @subpackage Structs
 */
class PolicyType extends AbstractStructBase
{
    /**
     * The PolicyNodeInfo
     * Meta information extracted from the WSDL
     * - documentation: Policy data node detail, including an XPATH and associated Tag Name.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PolicyNodeInfoType[]
     */
    public $PolicyNodeInfo;
    /**
     * The VersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Policy version number. Example: 2.17 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VersionNumber;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Source Entity Name or Code (e.g. BA, WIDGETCO). | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerName;
    /**
     * The PolicyTypeText
     * Meta information extracted from the WSDL
     * - documentation: Policy Type, examples: Policy Type. Examples: Privacy_PII, Payment_PCI, Credentialing | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PolicyTypeText;
    /**
     * Constructor method for PolicyType
     * @uses PolicyType::setPolicyNodeInfo()
     * @uses PolicyType::setVersionNumber()
     * @uses PolicyType::setDesc()
     * @uses PolicyType::setOwnerName()
     * @uses PolicyType::setPolicyTypeText()
     * @param \StructType\PolicyNodeInfoType[] $policyNodeInfo
     * @param float $versionNumber
     * @param \StructType\DescType[] $desc
     * @param string $ownerName
     * @param string $policyTypeText
     */
    public function __construct(array $policyNodeInfo = array(), $versionNumber = null, array $desc = array(), $ownerName = null, $policyTypeText = null)
    {
        $this
            ->setPolicyNodeInfo($policyNodeInfo)
            ->setVersionNumber($versionNumber)
            ->setDesc($desc)
            ->setOwnerName($ownerName)
            ->setPolicyTypeText($policyTypeText);
    }
    /**
     * Get PolicyNodeInfo value
     * @return \StructType\PolicyNodeInfoType[]
     */
    public function getPolicyNodeInfo()
    {
        return $this->PolicyNodeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicyNodeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyNodeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyNodeInfoForArrayConstraintsFromSetPolicyNodeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyTypePolicyNodeInfoItem) {
            // validation for constraint: itemType
            if (!$policyTypePolicyNodeInfoItem instanceof \StructType\PolicyNodeInfoType) {
                $invalidValues[] = is_object($policyTypePolicyNodeInfoItem) ? get_class($policyTypePolicyNodeInfoItem) : sprintf('%s(%s)', gettype($policyTypePolicyNodeInfoItem), var_export($policyTypePolicyNodeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PolicyNodeInfo property can only contain items of type \StructType\PolicyNodeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PolicyNodeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyNodeInfoType[] $policyNodeInfo
     * @return \StructType\PolicyType
     */
    public function setPolicyNodeInfo(array $policyNodeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($policyNodeInfoArrayErrorMessage = self::validatePolicyNodeInfoForArrayConstraintsFromSetPolicyNodeInfo($policyNodeInfo))) {
            throw new \InvalidArgumentException($policyNodeInfoArrayErrorMessage, __LINE__);
        }
        $this->PolicyNodeInfo = $policyNodeInfo;
        return $this;
    }
    /**
     * Add item to PolicyNodeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyNodeInfoType $item
     * @return \StructType\PolicyType
     */
    public function addToPolicyNodeInfo(\StructType\PolicyNodeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyNodeInfoType) {
            throw new \InvalidArgumentException(sprintf('The PolicyNodeInfo property can only contain items of type \StructType\PolicyNodeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PolicyNodeInfo[] = $item;
        return $this;
    }
    /**
     * Get VersionNumber value
     * @return float
     */
    public function getVersionNumber()
    {
        return $this->VersionNumber;
    }
    /**
     * Set VersionNumber value
     * @param float $versionNumber
     * @return \StructType\PolicyType
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: float
        if (!is_null($versionNumber) && !(is_float($versionNumber) || is_numeric($versionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        $this->VersionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policyTypeDescItem) {
            // validation for constraint: itemType
            if (!$policyTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($policyTypeDescItem) ? get_class($policyTypeDescItem) : sprintf('%s(%s)', gettype($policyTypeDescItem), var_export($policyTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\PolicyType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\PolicyType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get OwnerName value
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->OwnerName;
    }
    /**
     * Set OwnerName value
     * @param string $ownerName
     * @return \StructType\PolicyType
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        $this->OwnerName = $ownerName;
        return $this;
    }
    /**
     * Get PolicyTypeText value
     * @return string|null
     */
    public function getPolicyTypeText()
    {
        return $this->PolicyTypeText;
    }
    /**
     * Set PolicyTypeText value
     * @param string $policyTypeText
     * @return \StructType\PolicyType
     */
    public function setPolicyTypeText($policyTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($policyTypeText) && !is_string($policyTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyTypeText, true), gettype($policyTypeText)), __LINE__);
        }
        $this->PolicyTypeText = $policyTypeText;
        return $this;
    }
}
