<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyNodeInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Policy data node detail, including an XPATH and associated Tag Name.
 * @subpackage Structs
 */
class PolicyNodeInfoType extends AbstractStructBase
{
    /**
     * The PathText
     * Meta information extracted from the WSDL
     * - documentation: Message property location using XPATH syntax. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PathText;
    /**
     * The TagName
     * Meta information extracted from the WSDL
     * - documentation: Message property Tag name. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TagName;
    /**
     * Constructor method for PolicyNodeInfoType
     * @uses PolicyNodeInfoType::setPathText()
     * @uses PolicyNodeInfoType::setTagName()
     * @param string $pathText
     * @param string $tagName
     */
    public function __construct($pathText = null, $tagName = null)
    {
        $this
            ->setPathText($pathText)
            ->setTagName($tagName);
    }
    /**
     * Get PathText value
     * @return string|null
     */
    public function getPathText()
    {
        return $this->PathText;
    }
    /**
     * Set PathText value
     * @param string $pathText
     * @return \StructType\PolicyNodeInfoType
     */
    public function setPathText($pathText = null)
    {
        // validation for constraint: string
        if (!is_null($pathText) && !is_string($pathText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathText, true), gettype($pathText)), __LINE__);
        }
        $this->PathText = $pathText;
        return $this;
    }
    /**
     * Get TagName value
     * @return string|null
     */
    public function getTagName()
    {
        return $this->TagName;
    }
    /**
     * Set TagName value
     * @param string $tagName
     * @return \StructType\PolicyNodeInfoType
     */
    public function setTagName($tagName = null)
    {
        // validation for constraint: string
        if (!is_null($tagName) && !is_string($tagName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tagName, true), gettype($tagName)), __LINE__);
        }
        $this->TagName = $tagName;
        return $this;
    }
}
