<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a specialization of price when associated with a Penalty Base definition is: The amount of money expected, required, or given in payment for something.
 * @subpackage Structs
 */
class PenaltyPriceType extends AbstractStructBase
{
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Total Base Fare Amount. Example: 200000
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $BaseAmount;
    /**
     * The TaxSummary
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * Constructor method for PenaltyPriceType
     * @uses PenaltyPriceType::setTotalAmount()
     * @uses PenaltyPriceType::setBaseAmount()
     * @uses PenaltyPriceType::setTaxSummary()
     * @param \StructType\AmountType $totalAmount
     * @param \StructType\AmountType $baseAmount
     * @param \StructType\TaxSummaryType[] $taxSummary
     */
    public function __construct(\StructType\AmountType $totalAmount = null, \StructType\AmountType $baseAmount = null, array $taxSummary = array())
    {
        $this
            ->setTotalAmount($totalAmount)
            ->setBaseAmount($baseAmount)
            ->setTaxSummary($taxSummary);
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\PenaltyPriceType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return \StructType\AmountType|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param \StructType\AmountType $baseAmount
     * @return \StructType\PenaltyPriceType
     */
    public function setBaseAmount(\StructType\AmountType $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \StructType\TaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSummaryForArrayConstraintsFromSetTaxSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $penaltyPriceTypeTaxSummaryItem) {
            // validation for constraint: itemType
            if (!$penaltyPriceTypeTaxSummaryItem instanceof \StructType\TaxSummaryType) {
                $invalidValues[] = is_object($penaltyPriceTypeTaxSummaryItem) ? get_class($penaltyPriceTypeTaxSummaryItem) : sprintf('%s(%s)', gettype($penaltyPriceTypeTaxSummaryItem), var_export($penaltyPriceTypeTaxSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @return \StructType\PenaltyPriceType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSummaryArrayErrorMessage = self::validateTaxSummaryForArrayConstraintsFromSetTaxSummary($taxSummary))) {
            throw new \InvalidArgumentException($taxSummaryArrayErrorMessage, __LINE__);
        }
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType $item
     * @return \StructType\PenaltyPriceType
     */
    public function addToTaxSummary(\StructType\TaxSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxSummaryType) {
            throw new \InvalidArgumentException(sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSummary[] = $item;
        return $this;
    }
}
