<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Penalty data list definition.
 * @subpackage Structs
 */
class PenaltyListType extends AbstractStructBase
{
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - documentation: Information related to a punishment imposed for breaking a law, rule, or contract.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PenaltyType[]
     */
    public $Penalty;
    /**
     * Constructor method for PenaltyListType
     * @uses PenaltyListType::setPenalty()
     * @param \StructType\PenaltyType[] $penalty
     */
    public function __construct(array $penalty = array())
    {
        $this
            ->setPenalty($penalty);
    }
    /**
     * Get Penalty value
     * @return \StructType\PenaltyType[]
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * This method is responsible for validating the values passed to the setPenalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyForArrayConstraintsFromSetPenalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $penaltyListTypePenaltyItem) {
            // validation for constraint: itemType
            if (!$penaltyListTypePenaltyItem instanceof \StructType\PenaltyType) {
                $invalidValues[] = is_object($penaltyListTypePenaltyItem) ? get_class($penaltyListTypePenaltyItem) : sprintf('%s(%s)', gettype($penaltyListTypePenaltyItem), var_export($penaltyListTypePenaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Penalty property can only contain items of type \StructType\PenaltyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Penalty value
     * @throws \InvalidArgumentException
     * @param \StructType\PenaltyType[] $penalty
     * @return \StructType\PenaltyListType
     */
    public function setPenalty(array $penalty = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyArrayErrorMessage = self::validatePenaltyForArrayConstraintsFromSetPenalty($penalty))) {
            throw new \InvalidArgumentException($penaltyArrayErrorMessage, __LINE__);
        }
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Add item to Penalty value
     * @throws \InvalidArgumentException
     * @param \StructType\PenaltyType $item
     * @return \StructType\PenaltyListType
     */
    public function addToPenalty(\StructType\PenaltyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PenaltyType) {
            throw new \InvalidArgumentException(sprintf('The Penalty property can only contain items of type \StructType\PenaltyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Penalty[] = $item;
        return $this;
    }
}
