<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Penalty StructType
 * Meta information extracted from the WSDL
 * - documentation: Penalty/Change Fee amount returned by the auto-exchange application for requested transaction
 * @subpackage Structs
 */
class Penalty extends AbstractStructBase
{
    /**
     * The Amount
     * @var string
     */
    public $Amount;
    /**
     * Constructor method for Penalty
     * @uses Penalty::setAmount()
     * @param string $amount
     */
    public function __construct($amount = null)
    {
        $this
            ->setAmount($amount);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\Penalty
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
