<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTrxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional identification and URLs used to further describe a secure payment transaction.
 * @subpackage Structs
 */
class PaymentTrxType extends AbstractStructBase
{
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Transaction description information. Ex: Air Fare Two PAX | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The InputCurCode
     * Meta information extracted from the WSDL
     * - documentation: Input Payment Currency code. Example: USD | Currency Code enumeration information. {codeListAgencyName}ISO{/codeListAgencyName} {codeListIdentifier}4217{/codeListIdentifier} | Additional BDT to specify a currency code.
     * - base: CurCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InputCurCode;
    /**
     * The MaximumTryInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the maximum payment authentication attempts have been exceeded. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MaximumTryInd;
    /**
     * The NotProcessedInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the payment information has not been processed. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NotProcessedInd;
    /**
     * The OriginalID
     * Meta information extracted from the WSDL
     * - documentation: The identifier of the original transaction that initiated this Traveler authentication. Example: TRN12345 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that
     * is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalID;
    /**
     * The PaymentAddressVerification
     * Meta information extracted from the WSDL
     * - documentation: Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentAddressVerificationType
     */
    public $PaymentAddressVerification;
    /**
     * The RetryInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the payment transaction should be present. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RetryInd;
    /**
     * The SettlementCurCode
     * Meta information extracted from the WSDL
     * - documentation: Settlement Payment Currency code. Example: CHF | Currency Code enumeration information. {codeListAgencyName}ISO{/codeListAgencyName} {codeListIdentifier}4217{/codeListIdentifier} | Additional BDT to specify a currency code.
     * - base: CurCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementCurCode;
    /**
     * The TimestampDateTime
     * Meta information extracted from the WSDL
     * - documentation: 3DS transaction timestamp. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimestampDateTime;
    /**
     * The TrxDataText
     * Meta information extracted from the WSDL
     * - documentation: Other (free form text) transaction data. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $TrxDataText;
    /**
     * The TrxID
     * Meta information extracted from the WSDL
     * - documentation: Globally unique ID for a transaction processing instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrxID;
    /**
     * The TrxTypeText
     * Meta information extracted from the WSDL
     * - documentation: 3D Secure Transaction Type. Examples: Authorize: Authorize amount (no funds transferred) Complete: Complete a previous authorization (funds are transferred) Purchase: Purchase (funds are transferred immediately) Refund: Refund (funds
     * transferred immediately) Validate: Validation Transaction (a small authorized transaction amount to validate card details including expiry date and address) | Text is a character string such as a finite set of characters generally in the form of
     * words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrxTypeText;
    /**
     * Constructor method for PaymentTrxType
     * @uses PaymentTrxType::setDescText()
     * @uses PaymentTrxType::setInputCurCode()
     * @uses PaymentTrxType::setMaximumTryInd()
     * @uses PaymentTrxType::setNotProcessedInd()
     * @uses PaymentTrxType::setOriginalID()
     * @uses PaymentTrxType::setPaymentAddressVerification()
     * @uses PaymentTrxType::setRetryInd()
     * @uses PaymentTrxType::setSettlementCurCode()
     * @uses PaymentTrxType::setTimestampDateTime()
     * @uses PaymentTrxType::setTrxDataText()
     * @uses PaymentTrxType::setTrxID()
     * @uses PaymentTrxType::setTrxTypeText()
     * @param string $descText
     * @param string $inputCurCode
     * @param bool $maximumTryInd
     * @param bool $notProcessedInd
     * @param string $originalID
     * @param \StructType\PaymentAddressVerificationType $paymentAddressVerification
     * @param bool $retryInd
     * @param string $settlementCurCode
     * @param string $timestampDateTime
     * @param string[] $trxDataText
     * @param string $trxID
     * @param string $trxTypeText
     */
    public function __construct($descText = null, $inputCurCode = null, $maximumTryInd = null, $notProcessedInd = null, $originalID = null, \StructType\PaymentAddressVerificationType $paymentAddressVerification = null, $retryInd = null, $settlementCurCode = null, $timestampDateTime = null, array $trxDataText = array(), $trxID = null, $trxTypeText = null)
    {
        $this
            ->setDescText($descText)
            ->setInputCurCode($inputCurCode)
            ->setMaximumTryInd($maximumTryInd)
            ->setNotProcessedInd($notProcessedInd)
            ->setOriginalID($originalID)
            ->setPaymentAddressVerification($paymentAddressVerification)
            ->setRetryInd($retryInd)
            ->setSettlementCurCode($settlementCurCode)
            ->setTimestampDateTime($timestampDateTime)
            ->setTrxDataText($trxDataText)
            ->setTrxID($trxID)
            ->setTrxTypeText($trxTypeText);
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\PaymentTrxType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get InputCurCode value
     * @return string|null
     */
    public function getInputCurCode()
    {
        return $this->InputCurCode;
    }
    /**
     * Set InputCurCode value
     * @param string $inputCurCode
     * @return \StructType\PaymentTrxType
     */
    public function setInputCurCode($inputCurCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputCurCode) && !is_string($inputCurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputCurCode, true), gettype($inputCurCode)), __LINE__);
        }
        $this->InputCurCode = $inputCurCode;
        return $this;
    }
    /**
     * Get MaximumTryInd value
     * @return bool|null
     */
    public function getMaximumTryInd()
    {
        return $this->MaximumTryInd;
    }
    /**
     * Set MaximumTryInd value
     * @param bool $maximumTryInd
     * @return \StructType\PaymentTrxType
     */
    public function setMaximumTryInd($maximumTryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maximumTryInd) && !is_bool($maximumTryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maximumTryInd, true), gettype($maximumTryInd)), __LINE__);
        }
        $this->MaximumTryInd = $maximumTryInd;
        return $this;
    }
    /**
     * Get NotProcessedInd value
     * @return bool|null
     */
    public function getNotProcessedInd()
    {
        return $this->NotProcessedInd;
    }
    /**
     * Set NotProcessedInd value
     * @param bool $notProcessedInd
     * @return \StructType\PaymentTrxType
     */
    public function setNotProcessedInd($notProcessedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($notProcessedInd) && !is_bool($notProcessedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notProcessedInd, true), gettype($notProcessedInd)), __LINE__);
        }
        $this->NotProcessedInd = $notProcessedInd;
        return $this;
    }
    /**
     * Get OriginalID value
     * @return string|null
     */
    public function getOriginalID()
    {
        return $this->OriginalID;
    }
    /**
     * Set OriginalID value
     * @param string $originalID
     * @return \StructType\PaymentTrxType
     */
    public function setOriginalID($originalID = null)
    {
        // validation for constraint: string
        if (!is_null($originalID) && !is_string($originalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalID, true), gettype($originalID)), __LINE__);
        }
        $this->OriginalID = $originalID;
        return $this;
    }
    /**
     * Get PaymentAddressVerification value
     * @return \StructType\PaymentAddressVerificationType|null
     */
    public function getPaymentAddressVerification()
    {
        return $this->PaymentAddressVerification;
    }
    /**
     * Set PaymentAddressVerification value
     * @param \StructType\PaymentAddressVerificationType $paymentAddressVerification
     * @return \StructType\PaymentTrxType
     */
    public function setPaymentAddressVerification(\StructType\PaymentAddressVerificationType $paymentAddressVerification = null)
    {
        $this->PaymentAddressVerification = $paymentAddressVerification;
        return $this;
    }
    /**
     * Get RetryInd value
     * @return bool|null
     */
    public function getRetryInd()
    {
        return $this->RetryInd;
    }
    /**
     * Set RetryInd value
     * @param bool $retryInd
     * @return \StructType\PaymentTrxType
     */
    public function setRetryInd($retryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($retryInd) && !is_bool($retryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retryInd, true), gettype($retryInd)), __LINE__);
        }
        $this->RetryInd = $retryInd;
        return $this;
    }
    /**
     * Get SettlementCurCode value
     * @return string|null
     */
    public function getSettlementCurCode()
    {
        return $this->SettlementCurCode;
    }
    /**
     * Set SettlementCurCode value
     * @param string $settlementCurCode
     * @return \StructType\PaymentTrxType
     */
    public function setSettlementCurCode($settlementCurCode = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurCode) && !is_string($settlementCurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementCurCode, true), gettype($settlementCurCode)), __LINE__);
        }
        $this->SettlementCurCode = $settlementCurCode;
        return $this;
    }
    /**
     * Get TimestampDateTime value
     * @return string|null
     */
    public function getTimestampDateTime()
    {
        return $this->TimestampDateTime;
    }
    /**
     * Set TimestampDateTime value
     * @param string $timestampDateTime
     * @return \StructType\PaymentTrxType
     */
    public function setTimestampDateTime($timestampDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($timestampDateTime) && !is_string($timestampDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampDateTime, true), gettype($timestampDateTime)), __LINE__);
        }
        $this->TimestampDateTime = $timestampDateTime;
        return $this;
    }
    /**
     * Get TrxDataText value
     * @return string[]|null
     */
    public function getTrxDataText()
    {
        return $this->TrxDataText;
    }
    /**
     * This method is responsible for validating the values passed to the setTrxDataText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrxDataText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrxDataTextForArrayConstraintsFromSetTrxDataText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentTrxTypeTrxDataTextItem) {
            // validation for constraint: itemType
            if (!is_string($paymentTrxTypeTrxDataTextItem)) {
                $invalidValues[] = is_object($paymentTrxTypeTrxDataTextItem) ? get_class($paymentTrxTypeTrxDataTextItem) : sprintf('%s(%s)', gettype($paymentTrxTypeTrxDataTextItem), var_export($paymentTrxTypeTrxDataTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrxDataText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrxDataText value
     * @throws \InvalidArgumentException
     * @param string[] $trxDataText
     * @return \StructType\PaymentTrxType
     */
    public function setTrxDataText(array $trxDataText = array())
    {
        // validation for constraint: array
        if ('' !== ($trxDataTextArrayErrorMessage = self::validateTrxDataTextForArrayConstraintsFromSetTrxDataText($trxDataText))) {
            throw new \InvalidArgumentException($trxDataTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($trxDataText) && count($trxDataText) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($trxDataText)), __LINE__);
        }
        $this->TrxDataText = $trxDataText;
        return $this;
    }
    /**
     * Add item to TrxDataText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaymentTrxType
     */
    public function addToTrxDataText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TrxDataText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TrxDataText) && count($this->TrxDataText) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TrxDataText)), __LINE__);
        }
        $this->TrxDataText[] = $item;
        return $this;
    }
    /**
     * Get TrxID value
     * @return string|null
     */
    public function getTrxID()
    {
        return $this->TrxID;
    }
    /**
     * Set TrxID value
     * @param string $trxID
     * @return \StructType\PaymentTrxType
     */
    public function setTrxID($trxID = null)
    {
        // validation for constraint: string
        if (!is_null($trxID) && !is_string($trxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trxID, true), gettype($trxID)), __LINE__);
        }
        $this->TrxID = $trxID;
        return $this;
    }
    /**
     * Get TrxTypeText value
     * @return string|null
     */
    public function getTrxTypeText()
    {
        return $this->TrxTypeText;
    }
    /**
     * Set TrxTypeText value
     * @param string $trxTypeText
     * @return \StructType\PaymentTrxType
     */
    public function setTrxTypeText($trxTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($trxTypeText) && !is_string($trxTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trxTypeText, true), gettype($trxTypeText)), __LINE__);
        }
        $this->TrxTypeText = $trxTypeText;
        return $this;
    }
}
