<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentSurchargeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about surcharges for payment methods.
 * @subpackage Structs
 */
class PaymentSurchargeType extends AbstractStructBase
{
    /**
     * The AmountRangeMaximumAmount
     * Meta information extracted from the WSDL
     * - documentation: Maximum Amount of a Fee range of a payment method
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $AmountRangeMaximumAmount;
    /**
     * The AmountRangeMinimumAmount
     * Meta information extracted from the WSDL
     * - documentation: Minimum Amount of a Fee range of a payment method
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $AmountRangeMinimumAmount;
    /**
     * The PercentageRangeMaximumPercent
     * Meta information extracted from the WSDL
     * - documentation: Maximum Percentage value of a Fee range of a payment method | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PercentageRangeMaximumPercent;
    /**
     * The PercentageRangeMinimumPercent
     * Meta information extracted from the WSDL
     * - documentation: Minimum Percentage value of a Fee range of a payment method | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PercentageRangeMinimumPercent;
    /**
     * The PreciseAmount
     * Meta information extracted from the WSDL
     * - documentation: Maximum Amount of a Fee range of a payment method
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PreciseAmount;
    /**
     * The PrecisePercent
     * Meta information extracted from the WSDL
     * - documentation: Maximum Percentage value of a Fee range of a payment method | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PrecisePercent;
    /**
     * The RoundingNumberOfDecimalsNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of decimals of fee rounding | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $RoundingNumberOfDecimalsNumber;
    /**
     * The RoundingPrecisionCode
     * Meta information extracted from the WSDL
     * - documentation: precision of fee rounding | A type to determine the rounding precision
     * - base: RoundingPrecisionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoundingPrecisionCode;
    /**
     * Constructor method for PaymentSurchargeType
     * @uses PaymentSurchargeType::setAmountRangeMaximumAmount()
     * @uses PaymentSurchargeType::setAmountRangeMinimumAmount()
     * @uses PaymentSurchargeType::setPercentageRangeMaximumPercent()
     * @uses PaymentSurchargeType::setPercentageRangeMinimumPercent()
     * @uses PaymentSurchargeType::setPreciseAmount()
     * @uses PaymentSurchargeType::setPrecisePercent()
     * @uses PaymentSurchargeType::setRoundingNumberOfDecimalsNumber()
     * @uses PaymentSurchargeType::setRoundingPrecisionCode()
     * @param \StructType\AmountType $amountRangeMaximumAmount
     * @param \StructType\AmountType $amountRangeMinimumAmount
     * @param float $percentageRangeMaximumPercent
     * @param float $percentageRangeMinimumPercent
     * @param \StructType\AmountType $preciseAmount
     * @param float $precisePercent
     * @param float $roundingNumberOfDecimalsNumber
     * @param string $roundingPrecisionCode
     */
    public function __construct(\StructType\AmountType $amountRangeMaximumAmount = null, \StructType\AmountType $amountRangeMinimumAmount = null, $percentageRangeMaximumPercent = null, $percentageRangeMinimumPercent = null, \StructType\AmountType $preciseAmount = null, $precisePercent = null, $roundingNumberOfDecimalsNumber = null, $roundingPrecisionCode = null)
    {
        $this
            ->setAmountRangeMaximumAmount($amountRangeMaximumAmount)
            ->setAmountRangeMinimumAmount($amountRangeMinimumAmount)
            ->setPercentageRangeMaximumPercent($percentageRangeMaximumPercent)
            ->setPercentageRangeMinimumPercent($percentageRangeMinimumPercent)
            ->setPreciseAmount($preciseAmount)
            ->setPrecisePercent($precisePercent)
            ->setRoundingNumberOfDecimalsNumber($roundingNumberOfDecimalsNumber)
            ->setRoundingPrecisionCode($roundingPrecisionCode);
    }
    /**
     * Get AmountRangeMaximumAmount value
     * @return \StructType\AmountType|null
     */
    public function getAmountRangeMaximumAmount()
    {
        return $this->AmountRangeMaximumAmount;
    }
    /**
     * Set AmountRangeMaximumAmount value
     * @param \StructType\AmountType $amountRangeMaximumAmount
     * @return \StructType\PaymentSurchargeType
     */
    public function setAmountRangeMaximumAmount(\StructType\AmountType $amountRangeMaximumAmount = null)
    {
        $this->AmountRangeMaximumAmount = $amountRangeMaximumAmount;
        return $this;
    }
    /**
     * Get AmountRangeMinimumAmount value
     * @return \StructType\AmountType|null
     */
    public function getAmountRangeMinimumAmount()
    {
        return $this->AmountRangeMinimumAmount;
    }
    /**
     * Set AmountRangeMinimumAmount value
     * @param \StructType\AmountType $amountRangeMinimumAmount
     * @return \StructType\PaymentSurchargeType
     */
    public function setAmountRangeMinimumAmount(\StructType\AmountType $amountRangeMinimumAmount = null)
    {
        $this->AmountRangeMinimumAmount = $amountRangeMinimumAmount;
        return $this;
    }
    /**
     * Get PercentageRangeMaximumPercent value
     * @return float|null
     */
    public function getPercentageRangeMaximumPercent()
    {
        return $this->PercentageRangeMaximumPercent;
    }
    /**
     * Set PercentageRangeMaximumPercent value
     * @param float $percentageRangeMaximumPercent
     * @return \StructType\PaymentSurchargeType
     */
    public function setPercentageRangeMaximumPercent($percentageRangeMaximumPercent = null)
    {
        // validation for constraint: float
        if (!is_null($percentageRangeMaximumPercent) && !(is_float($percentageRangeMaximumPercent) || is_numeric($percentageRangeMaximumPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentageRangeMaximumPercent, true), gettype($percentageRangeMaximumPercent)), __LINE__);
        }
        $this->PercentageRangeMaximumPercent = $percentageRangeMaximumPercent;
        return $this;
    }
    /**
     * Get PercentageRangeMinimumPercent value
     * @return float|null
     */
    public function getPercentageRangeMinimumPercent()
    {
        return $this->PercentageRangeMinimumPercent;
    }
    /**
     * Set PercentageRangeMinimumPercent value
     * @param float $percentageRangeMinimumPercent
     * @return \StructType\PaymentSurchargeType
     */
    public function setPercentageRangeMinimumPercent($percentageRangeMinimumPercent = null)
    {
        // validation for constraint: float
        if (!is_null($percentageRangeMinimumPercent) && !(is_float($percentageRangeMinimumPercent) || is_numeric($percentageRangeMinimumPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentageRangeMinimumPercent, true), gettype($percentageRangeMinimumPercent)), __LINE__);
        }
        $this->PercentageRangeMinimumPercent = $percentageRangeMinimumPercent;
        return $this;
    }
    /**
     * Get PreciseAmount value
     * @return \StructType\AmountType|null
     */
    public function getPreciseAmount()
    {
        return $this->PreciseAmount;
    }
    /**
     * Set PreciseAmount value
     * @param \StructType\AmountType $preciseAmount
     * @return \StructType\PaymentSurchargeType
     */
    public function setPreciseAmount(\StructType\AmountType $preciseAmount = null)
    {
        $this->PreciseAmount = $preciseAmount;
        return $this;
    }
    /**
     * Get PrecisePercent value
     * @return float|null
     */
    public function getPrecisePercent()
    {
        return $this->PrecisePercent;
    }
    /**
     * Set PrecisePercent value
     * @param float $precisePercent
     * @return \StructType\PaymentSurchargeType
     */
    public function setPrecisePercent($precisePercent = null)
    {
        // validation for constraint: float
        if (!is_null($precisePercent) && !(is_float($precisePercent) || is_numeric($precisePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precisePercent, true), gettype($precisePercent)), __LINE__);
        }
        $this->PrecisePercent = $precisePercent;
        return $this;
    }
    /**
     * Get RoundingNumberOfDecimalsNumber value
     * @return float|null
     */
    public function getRoundingNumberOfDecimalsNumber()
    {
        return $this->RoundingNumberOfDecimalsNumber;
    }
    /**
     * Set RoundingNumberOfDecimalsNumber value
     * @param float $roundingNumberOfDecimalsNumber
     * @return \StructType\PaymentSurchargeType
     */
    public function setRoundingNumberOfDecimalsNumber($roundingNumberOfDecimalsNumber = null)
    {
        // validation for constraint: float
        if (!is_null($roundingNumberOfDecimalsNumber) && !(is_float($roundingNumberOfDecimalsNumber) || is_numeric($roundingNumberOfDecimalsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roundingNumberOfDecimalsNumber, true), gettype($roundingNumberOfDecimalsNumber)), __LINE__);
        }
        $this->RoundingNumberOfDecimalsNumber = $roundingNumberOfDecimalsNumber;
        return $this;
    }
    /**
     * Get RoundingPrecisionCode value
     * @return string|null
     */
    public function getRoundingPrecisionCode()
    {
        return $this->RoundingPrecisionCode;
    }
    /**
     * Set RoundingPrecisionCode value
     * @param string $roundingPrecisionCode
     * @return \StructType\PaymentSurchargeType
     */
    public function setRoundingPrecisionCode($roundingPrecisionCode = null)
    {
        // validation for constraint: string
        if (!is_null($roundingPrecisionCode) && !is_string($roundingPrecisionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roundingPrecisionCode, true), gettype($roundingPrecisionCode)), __LINE__);
        }
        $this->RoundingPrecisionCode = $roundingPrecisionCode;
        return $this;
    }
}
