<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentSupportedMethodType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information relating to payment method acceptance. This always relates to the airlines payment acceptance terms regardless of preference expressed by a seller using PaymentCriteria.
 * @subpackage Structs
 */
class PaymentSupportedMethodType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Type code assigned according to ATS Codeset PAYT. For example: 'CC' for Customer Card. | The type code as in 'Credit card' used for a payment. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment
     * Type, coded{/codeListName} {codeListIdentifier}PAYT{/codeListIdentifier} | Additional payment type codes for use in Enhanced and Simplified, refer to IATA code set PAYT
     * - base: PaymentTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The ClearanceMethods
     * Meta information extracted from the WSDL
     * - documentation: These are the clearance options with their supporting information proposed by the carrier for a given offer. It supplies the methods available to clear a payment. It is part of the 'Payment Supported Method', and it is relevant
     * whenever the method of payment will require clearance of funds between the partners of the sale. Includes the Commission data to allow the carrier to support choices that are in line with its payment policy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ClearanceMethodsType[]
     */
    public $ClearanceMethods;
    /**
     * The CryptographyKey
     * Meta information extracted from the WSDL
     * - documentation: Cryptography Key.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CryptographyKeyType
     */
    public $CryptographyKey;
    /**
     * The PaymentBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Brand code assigned according to ATS Codeset PAYB. Example VI for Visa | Enumeration of Additional Payment Brand codes for use in Enhanced and Simplified Distribution Standards {codeListAgencyName}IATA Code
     * List{/codeListAgencyName} {codeListName}Payment Brand, Coded{/codeListName} {codeListIdentifier}PAYB{/codeListIdentifier} | Additional Payment Brand codes for use in Enhanced and Simplified Distribution Standards, refer to IATA code set PAYB
     * - base: PaymentBrandCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentBrandCode;
    /**
     * The PaymentMethodAddlInfo
     * Meta information extracted from the WSDL
     * - documentation: a Payment Method Additional Information
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentMethodAddlInfoType
     */
    public $PaymentMethodAddlInfo;
    /**
     * The PaymentMethodCountryCode
     * Meta information extracted from the WSDL
     * - documentation: The country in which the payment method was issued or created. Fir example: 'US' for a card issued in the United States or 'AU' for an e-wallet account created in Australia. | The code list of ISO 3166 two-alpha Country Codes
     * {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $PaymentMethodCountryCode;
    /**
     * The PaymentRedirectionInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates that an Airline will capture payment via a separate hosted payment platform, e.g. via a URI generated by an airline's payment platform | An indicator is a list of two mutually exclusive Boolean values that express the only
     * possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaymentRedirectionInd;
    /**
     * The PaymentSurcharge
     * Meta information extracted from the WSDL
     * - documentation: Information about surcharges for payment methods.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentSurchargeType
     */
    public $PaymentSurcharge;
    /**
     * Constructor method for PaymentSupportedMethodType
     * @uses PaymentSupportedMethodType::setPaymentTypeCode()
     * @uses PaymentSupportedMethodType::setClearanceMethods()
     * @uses PaymentSupportedMethodType::setCryptographyKey()
     * @uses PaymentSupportedMethodType::setPaymentBrandCode()
     * @uses PaymentSupportedMethodType::setPaymentMethodAddlInfo()
     * @uses PaymentSupportedMethodType::setPaymentMethodCountryCode()
     * @uses PaymentSupportedMethodType::setPaymentRedirectionInd()
     * @uses PaymentSupportedMethodType::setPaymentSurcharge()
     * @param string $paymentTypeCode
     * @param \StructType\ClearanceMethodsType[] $clearanceMethods
     * @param \StructType\CryptographyKeyType $cryptographyKey
     * @param string $paymentBrandCode
     * @param \StructType\PaymentMethodAddlInfoType $paymentMethodAddlInfo
     * @param string $paymentMethodCountryCode
     * @param bool $paymentRedirectionInd
     * @param \StructType\PaymentSurchargeType $paymentSurcharge
     */
    public function __construct($paymentTypeCode = null, array $clearanceMethods = array(), \StructType\CryptographyKeyType $cryptographyKey = null, $paymentBrandCode = null, \StructType\PaymentMethodAddlInfoType $paymentMethodAddlInfo = null, $paymentMethodCountryCode = null, $paymentRedirectionInd = null, \StructType\PaymentSurchargeType $paymentSurcharge = null)
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setClearanceMethods($clearanceMethods)
            ->setCryptographyKey($cryptographyKey)
            ->setPaymentBrandCode($paymentBrandCode)
            ->setPaymentMethodAddlInfo($paymentMethodAddlInfo)
            ->setPaymentMethodCountryCode($paymentMethodCountryCode)
            ->setPaymentRedirectionInd($paymentRedirectionInd)
            ->setPaymentSurcharge($paymentSurcharge);
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get ClearanceMethods value
     * @return \StructType\ClearanceMethodsType[]|null
     */
    public function getClearanceMethods()
    {
        return $this->ClearanceMethods;
    }
    /**
     * This method is responsible for validating the values passed to the setClearanceMethods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClearanceMethods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClearanceMethodsForArrayConstraintsFromSetClearanceMethods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentSupportedMethodTypeClearanceMethodsItem) {
            // validation for constraint: itemType
            if (!$paymentSupportedMethodTypeClearanceMethodsItem instanceof \StructType\ClearanceMethodsType) {
                $invalidValues[] = is_object($paymentSupportedMethodTypeClearanceMethodsItem) ? get_class($paymentSupportedMethodTypeClearanceMethodsItem) : sprintf('%s(%s)', gettype($paymentSupportedMethodTypeClearanceMethodsItem), var_export($paymentSupportedMethodTypeClearanceMethodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClearanceMethods property can only contain items of type \StructType\ClearanceMethodsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClearanceMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceMethodsType[] $clearanceMethods
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setClearanceMethods(array $clearanceMethods = array())
    {
        // validation for constraint: array
        if ('' !== ($clearanceMethodsArrayErrorMessage = self::validateClearanceMethodsForArrayConstraintsFromSetClearanceMethods($clearanceMethods))) {
            throw new \InvalidArgumentException($clearanceMethodsArrayErrorMessage, __LINE__);
        }
        $this->ClearanceMethods = $clearanceMethods;
        return $this;
    }
    /**
     * Add item to ClearanceMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceMethodsType $item
     * @return \StructType\PaymentSupportedMethodType
     */
    public function addToClearanceMethods(\StructType\ClearanceMethodsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClearanceMethodsType) {
            throw new \InvalidArgumentException(sprintf('The ClearanceMethods property can only contain items of type \StructType\ClearanceMethodsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClearanceMethods[] = $item;
        return $this;
    }
    /**
     * Get CryptographyKey value
     * @return \StructType\CryptographyKeyType|null
     */
    public function getCryptographyKey()
    {
        return $this->CryptographyKey;
    }
    /**
     * Set CryptographyKey value
     * @param \StructType\CryptographyKeyType $cryptographyKey
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setCryptographyKey(\StructType\CryptographyKeyType $cryptographyKey = null)
    {
        $this->CryptographyKey = $cryptographyKey;
        return $this;
    }
    /**
     * Get PaymentBrandCode value
     * @return string|null
     */
    public function getPaymentBrandCode()
    {
        return $this->PaymentBrandCode;
    }
    /**
     * Set PaymentBrandCode value
     * @param string $paymentBrandCode
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setPaymentBrandCode($paymentBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBrandCode) && !is_string($paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBrandCode, true), gettype($paymentBrandCode)), __LINE__);
        }
        $this->PaymentBrandCode = $paymentBrandCode;
        return $this;
    }
    /**
     * Get PaymentMethodAddlInfo value
     * @return \StructType\PaymentMethodAddlInfoType|null
     */
    public function getPaymentMethodAddlInfo()
    {
        return $this->PaymentMethodAddlInfo;
    }
    /**
     * Set PaymentMethodAddlInfo value
     * @param \StructType\PaymentMethodAddlInfoType $paymentMethodAddlInfo
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setPaymentMethodAddlInfo(\StructType\PaymentMethodAddlInfoType $paymentMethodAddlInfo = null)
    {
        $this->PaymentMethodAddlInfo = $paymentMethodAddlInfo;
        return $this;
    }
    /**
     * Get PaymentMethodCountryCode value
     * @return string|null
     */
    public function getPaymentMethodCountryCode()
    {
        return $this->PaymentMethodCountryCode;
    }
    /**
     * Set PaymentMethodCountryCode value
     * @param string $paymentMethodCountryCode
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setPaymentMethodCountryCode($paymentMethodCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodCountryCode) && !is_string($paymentMethodCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodCountryCode, true), gettype($paymentMethodCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($paymentMethodCountryCode) && !preg_match('/[A-Z]{2}/', $paymentMethodCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($paymentMethodCountryCode, true)), __LINE__);
        }
        $this->PaymentMethodCountryCode = $paymentMethodCountryCode;
        return $this;
    }
    /**
     * Get PaymentRedirectionInd value
     * @return bool|null
     */
    public function getPaymentRedirectionInd()
    {
        return $this->PaymentRedirectionInd;
    }
    /**
     * Set PaymentRedirectionInd value
     * @param bool $paymentRedirectionInd
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setPaymentRedirectionInd($paymentRedirectionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentRedirectionInd) && !is_bool($paymentRedirectionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentRedirectionInd, true), gettype($paymentRedirectionInd)), __LINE__);
        }
        $this->PaymentRedirectionInd = $paymentRedirectionInd;
        return $this;
    }
    /**
     * Get PaymentSurcharge value
     * @return \StructType\PaymentSurchargeType|null
     */
    public function getPaymentSurcharge()
    {
        return $this->PaymentSurcharge;
    }
    /**
     * Set PaymentSurcharge value
     * @param \StructType\PaymentSurchargeType $paymentSurcharge
     * @return \StructType\PaymentSupportedMethodType
     */
    public function setPaymentSurcharge(\StructType\PaymentSurchargeType $paymentSurcharge = null)
    {
        $this->PaymentSurcharge = $paymentSurcharge;
        return $this;
    }
}
