<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentOtherMethodAddlInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional Information for other payment criteria. For use with PaymentTypeCode(s) relating to Other forms of payment
 * @subpackage Structs
 */
class PaymentOtherMethodAddlInfoType extends AbstractStructBase
{
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * Constructor method for PaymentOtherMethodAddlInfoType
     * @uses PaymentOtherMethodAddlInfoType::setRemark()
     * @param \StructType\RemarkType[] $remark
     */
    public function __construct(array $remark = array())
    {
        $this
            ->setRemark($remark);
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentOtherMethodAddlInfoTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$paymentOtherMethodAddlInfoTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($paymentOtherMethodAddlInfoTypeRemarkItem) ? get_class($paymentOtherMethodAddlInfoTypeRemarkItem) : sprintf('%s(%s)', gettype($paymentOtherMethodAddlInfoTypeRemarkItem), var_export($paymentOtherMethodAddlInfoTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\PaymentOtherMethodAddlInfoType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\PaymentOtherMethodAddlInfoType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
}
