<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodAddlInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: a Payment Method Additional Information
 * @subpackage Structs
 */
class PaymentMethodAddlInfoType extends AbstractStructBase
{
    /**
     * The PaymentCardAddlInfo
     * Meta information extracted from the WSDL
     * - documentation: Additional Information relating to Payment Cards. For use with PaymentTypeCode(s) relating to Card forms of payment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentCardAddlInfoType
     */
    public $PaymentCardAddlInfo;
    /**
     * The PaymentOtherMethodAddlInfo
     * Meta information extracted from the WSDL
     * - documentation: Additional Information for other payment criteria. For use with PaymentTypeCode(s) relating to Other forms of payment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentOtherMethodAddlInfoType
     */
    public $PaymentOtherMethodAddlInfo;
    /**
     * Constructor method for PaymentMethodAddlInfoType
     * @uses PaymentMethodAddlInfoType::setPaymentCardAddlInfo()
     * @uses PaymentMethodAddlInfoType::setPaymentOtherMethodAddlInfo()
     * @param \StructType\PaymentCardAddlInfoType $paymentCardAddlInfo
     * @param \StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo
     */
    public function __construct(\StructType\PaymentCardAddlInfoType $paymentCardAddlInfo = null, \StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo = null)
    {
        $this
            ->setPaymentCardAddlInfo($paymentCardAddlInfo)
            ->setPaymentOtherMethodAddlInfo($paymentOtherMethodAddlInfo);
    }
    /**
     * Get PaymentCardAddlInfo value
     * @return \StructType\PaymentCardAddlInfoType|null
     */
    public function getPaymentCardAddlInfo()
    {
        return $this->PaymentCardAddlInfo;
    }
    /**
     * Set PaymentCardAddlInfo value
     * @param \StructType\PaymentCardAddlInfoType $paymentCardAddlInfo
     * @return \StructType\PaymentMethodAddlInfoType
     */
    public function setPaymentCardAddlInfo(\StructType\PaymentCardAddlInfoType $paymentCardAddlInfo = null)
    {
        $this->PaymentCardAddlInfo = $paymentCardAddlInfo;
        return $this;
    }
    /**
     * Get PaymentOtherMethodAddlInfo value
     * @return \StructType\PaymentOtherMethodAddlInfoType|null
     */
    public function getPaymentOtherMethodAddlInfo()
    {
        return $this->PaymentOtherMethodAddlInfo;
    }
    /**
     * Set PaymentOtherMethodAddlInfo value
     * @param \StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo
     * @return \StructType\PaymentMethodAddlInfoType
     */
    public function setPaymentOtherMethodAddlInfo(\StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo = null)
    {
        $this->PaymentOtherMethodAddlInfo = $paymentOtherMethodAddlInfo;
        return $this;
    }
}
