<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment card specific filter criteria for shopping requests, including card issuer type and identification number.
 * @subpackage Structs
 */
class PaymentCardCriteriaType extends AbstractStructBase
{
    /**
     * The CardBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A two-letter code assigned according to IATA Resolution 728. Example: VI for Visa | ENUM to specify the CC vendor code in case FOID is a Credit Card (e.g. VI, MC, etc). | Additional BDT to specify the CC vendor code in case FOID is a
     * Credit Card.
     * - base: CreditCardVendorCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-zA-Z]{1,2}
     * @var string
     */
    public $CardBrandCode;
    /**
     * The CardIssuingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Payment Card issuing country code. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha
     * Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CardIssuingCountryCode;
    /**
     * The CardProductTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardProductTypeCode;
    /**
     * The SecureAuthenticationVersion
     * Meta information extracted from the WSDL
     * - documentation: Used by Seller if 3D-Secure is supported. Seller can specify which version of 3D-Secure is supported. Note: 3D-Secure context should be used when the Customer-Seller interaction type is web and/or mobile.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurePaymentAuthenticationVersionType
     */
    public $SecureAuthenticationVersion;
    /**
     * Constructor method for PaymentCardCriteriaType
     * @uses PaymentCardCriteriaType::setCardBrandCode()
     * @uses PaymentCardCriteriaType::setCardIssuingCountryCode()
     * @uses PaymentCardCriteriaType::setCardProductTypeCode()
     * @uses PaymentCardCriteriaType::setSecureAuthenticationVersion()
     * @param string $cardBrandCode
     * @param string $cardIssuingCountryCode
     * @param string $cardProductTypeCode
     * @param \StructType\SecurePaymentAuthenticationVersionType $secureAuthenticationVersion
     */
    public function __construct($cardBrandCode = null, $cardIssuingCountryCode = null, $cardProductTypeCode = null, \StructType\SecurePaymentAuthenticationVersionType $secureAuthenticationVersion = null)
    {
        $this
            ->setCardBrandCode($cardBrandCode)
            ->setCardIssuingCountryCode($cardIssuingCountryCode)
            ->setCardProductTypeCode($cardProductTypeCode)
            ->setSecureAuthenticationVersion($secureAuthenticationVersion);
    }
    /**
     * Get CardBrandCode value
     * @return string
     */
    public function getCardBrandCode()
    {
        return $this->CardBrandCode;
    }
    /**
     * Set CardBrandCode value
     * @param string $cardBrandCode
     * @return \StructType\PaymentCardCriteriaType
     */
    public function setCardBrandCode($cardBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardBrandCode) && !is_string($cardBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardBrandCode, true), gettype($cardBrandCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,2})
        if (!is_null($cardBrandCode) && !preg_match('/[0-9a-zA-Z]{1,2}/', $cardBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,2}', var_export($cardBrandCode, true)), __LINE__);
        }
        $this->CardBrandCode = $cardBrandCode;
        return $this;
    }
    /**
     * Get CardIssuingCountryCode value
     * @return string|null
     */
    public function getCardIssuingCountryCode()
    {
        return $this->CardIssuingCountryCode;
    }
    /**
     * Set CardIssuingCountryCode value
     * @param string $cardIssuingCountryCode
     * @return \StructType\PaymentCardCriteriaType
     */
    public function setCardIssuingCountryCode($cardIssuingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssuingCountryCode) && !is_string($cardIssuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssuingCountryCode, true), gettype($cardIssuingCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($cardIssuingCountryCode) && !preg_match('/[A-Z]{2}/', $cardIssuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($cardIssuingCountryCode, true)), __LINE__);
        }
        $this->CardIssuingCountryCode = $cardIssuingCountryCode;
        return $this;
    }
    /**
     * Get CardProductTypeCode value
     * @return string|null
     */
    public function getCardProductTypeCode()
    {
        return $this->CardProductTypeCode;
    }
    /**
     * Set CardProductTypeCode value
     * @param string $cardProductTypeCode
     * @return \StructType\PaymentCardCriteriaType
     */
    public function setCardProductTypeCode($cardProductTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardProductTypeCode) && !is_string($cardProductTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProductTypeCode, true), gettype($cardProductTypeCode)), __LINE__);
        }
        $this->CardProductTypeCode = $cardProductTypeCode;
        return $this;
    }
    /**
     * Get SecureAuthenticationVersion value
     * @return \StructType\SecurePaymentAuthenticationVersionType|null
     */
    public function getSecureAuthenticationVersion()
    {
        return $this->SecureAuthenticationVersion;
    }
    /**
     * Set SecureAuthenticationVersion value
     * @param \StructType\SecurePaymentAuthenticationVersionType $secureAuthenticationVersion
     * @return \StructType\PaymentCardCriteriaType
     */
    public function setSecureAuthenticationVersion(\StructType\SecurePaymentAuthenticationVersionType $secureAuthenticationVersion = null)
    {
        $this->SecureAuthenticationVersion = $secureAuthenticationVersion;
        return $this;
    }
}
