<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayloadRestrictionsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enables restriction of message payloads for selected objects.
 * @subpackage Structs
 */
class PayloadRestrictionsType extends AbstractStructBase
{
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - documentation: This will specify the maximum number of the given associated record type that will be returned in response to the request message. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Limit;
    /**
     * The ObjectName
     * Meta information extracted from the WSDL
     * - documentation: This defines the type of record that will be restricted by the maximum record count. | This will contain a list of allowable object names defined as a code. This will be defined using an ENUM.
     * - base: ObjectNameCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectName;
    /**
     * Constructor method for PayloadRestrictionsType
     * @uses PayloadRestrictionsType::setLimit()
     * @uses PayloadRestrictionsType::setObjectName()
     * @param float $limit
     * @param string $objectName
     */
    public function __construct($limit = null, $objectName = null)
    {
        $this
            ->setLimit($limit)
            ->setObjectName($objectName);
    }
    /**
     * Get Limit value
     * @return float|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param float $limit
     * @return \StructType\PayloadRestrictionsType
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: float
        if (!is_null($limit) && !(is_float($limit) || is_numeric($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get ObjectName value
     * @return string|null
     */
    public function getObjectName()
    {
        return $this->ObjectName;
    }
    /**
     * Set ObjectName value
     * @param string $objectName
     * @return \StructType\PayloadRestrictionsType
     */
    public function setObjectName($objectName = null)
    {
        // validation for constraint: string
        if (!is_null($objectName) && !is_string($objectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectName, true), gettype($objectName)), __LINE__);
        }
        $this->ObjectName = $objectName;
        return $this;
    }
}
