<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxSharingPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: This will be used to identify a Passenger's sharing preference. The passenger can request that his/her information is not shared with other passengers in the same order. Additionally the passenger can be in a requested selected group
 * of passengers whom wish to not share with the remaining passengers in the booking . E.g could be a group of a family members in a larger group booking.
 * @subpackage Structs
 */
class PaxSharingPrefType extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The SharingInd
     * Meta information extracted from the WSDL
     * - documentation: Identifies if the passenger wants to stop sharing his data with the other passengers not in his group. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SharingInd;
    /**
     * The SharingPartyID
     * Meta information extracted from the WSDL
     * - documentation: identifies a group which can contain one or more passengers. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SharingPartyID;
    /**
     * Constructor method for PaxSharingPrefType
     * @uses PaxSharingPrefType::setPaxRefID()
     * @uses PaxSharingPrefType::setSharingInd()
     * @uses PaxSharingPrefType::setSharingPartyID()
     * @param string $paxRefID
     * @param bool $sharingInd
     * @param string $sharingPartyID
     */
    public function __construct($paxRefID = null, $sharingInd = null, $sharingPartyID = null)
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setSharingInd($sharingInd)
            ->setSharingPartyID($sharingPartyID);
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\PaxSharingPrefType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get SharingInd value
     * @return bool|null
     */
    public function getSharingInd()
    {
        return $this->SharingInd;
    }
    /**
     * Set SharingInd value
     * @param bool $sharingInd
     * @return \StructType\PaxSharingPrefType
     */
    public function setSharingInd($sharingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sharingInd) && !is_bool($sharingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sharingInd, true), gettype($sharingInd)), __LINE__);
        }
        $this->SharingInd = $sharingInd;
        return $this;
    }
    /**
     * Get SharingPartyID value
     * @return string|null
     */
    public function getSharingPartyID()
    {
        return $this->SharingPartyID;
    }
    /**
     * Set SharingPartyID value
     * @param string $sharingPartyID
     * @return \StructType\PaxSharingPrefType
     */
    public function setSharingPartyID($sharingPartyID = null)
    {
        // validation for constraint: string
        if (!is_null($sharingPartyID) && !is_string($sharingPartyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharingPartyID, true), gettype($sharingPartyID)), __LINE__);
        }
        $this->SharingPartyID = $sharingPartyID;
        return $this;
    }
}
