<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
 * @subpackage Structs
 */
class PaxSegmentType extends AbstractStructBase
{
    /**
     * The DatedMarketingSegmentRefId
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique identifier of a dated marketing segment used in a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedMarketingSegmentRefId;
    /**
     * The PaxSegmentID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Segment within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentID;
    /**
     * The CabinTypeAssociationChoice
     * Meta information extracted from the WSDL
     * - documentation: A choice of Cabin Type Association to leg(s) or a segment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeAssociationChoiceType
     */
    public $CabinTypeAssociationChoice;
    /**
     * The MarketingCarrierRBD_Code
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify a particular RBD (e.g. P, J, W, M, etc.). | Enumeration values of RBD Codes as per PADIS codeset 9800. {codeListAgencyName}IATA{/codeListAgencyName} {codeListIdentifier}PADIS 9800{/codeListIdentifier} |
     * Additional BDT to specify the RBD as defined in AIRIMP and SSIM.
     * - base: RBD_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketingCarrierRBD_Code;
    /**
     * The OperatingCarrierRBD_Code
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify a particular RBD (e.g. P, J, W, M, etc.). | Enumeration values of RBD Codes as per PADIS codeset 9800. {codeListAgencyName}IATA{/codeListAgencyName} {codeListIdentifier}PADIS 9800{/codeListIdentifier} |
     * Additional BDT to specify the RBD as defined in AIRIMP and SSIM.
     * - base: RBD_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingCarrierRBD_Code;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType
     */
    public $SettlementInfo;
    /**
     * Constructor method for PaxSegmentType
     * @uses PaxSegmentType::setDatedMarketingSegmentRefId()
     * @uses PaxSegmentType::setPaxSegmentID()
     * @uses PaxSegmentType::setCabinTypeAssociationChoice()
     * @uses PaxSegmentType::setMarketingCarrierRBD_Code()
     * @uses PaxSegmentType::setOperatingCarrierRBD_Code()
     * @uses PaxSegmentType::setSettlementInfo()
     * @param string $datedMarketingSegmentRefId
     * @param string $paxSegmentID
     * @param \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice
     * @param string $marketingCarrierRBD_Code
     * @param string $operatingCarrierRBD_Code
     * @param \StructType\SettlementInfoType $settlementInfo
     */
    public function __construct($datedMarketingSegmentRefId = null, $paxSegmentID = null, \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice = null, $marketingCarrierRBD_Code = null, $operatingCarrierRBD_Code = null, \StructType\SettlementInfoType $settlementInfo = null)
    {
        $this
            ->setDatedMarketingSegmentRefId($datedMarketingSegmentRefId)
            ->setPaxSegmentID($paxSegmentID)
            ->setCabinTypeAssociationChoice($cabinTypeAssociationChoice)
            ->setMarketingCarrierRBD_Code($marketingCarrierRBD_Code)
            ->setOperatingCarrierRBD_Code($operatingCarrierRBD_Code)
            ->setSettlementInfo($settlementInfo);
    }
    /**
     * Get DatedMarketingSegmentRefId value
     * @return string
     */
    public function getDatedMarketingSegmentRefId()
    {
        return $this->DatedMarketingSegmentRefId;
    }
    /**
     * Set DatedMarketingSegmentRefId value
     * @param string $datedMarketingSegmentRefId
     * @return \StructType\PaxSegmentType
     */
    public function setDatedMarketingSegmentRefId($datedMarketingSegmentRefId = null)
    {
        // validation for constraint: string
        if (!is_null($datedMarketingSegmentRefId) && !is_string($datedMarketingSegmentRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedMarketingSegmentRefId, true), gettype($datedMarketingSegmentRefId)), __LINE__);
        }
        $this->DatedMarketingSegmentRefId = $datedMarketingSegmentRefId;
        return $this;
    }
    /**
     * Get PaxSegmentID value
     * @return string
     */
    public function getPaxSegmentID()
    {
        return $this->PaxSegmentID;
    }
    /**
     * Set PaxSegmentID value
     * @param string $paxSegmentID
     * @return \StructType\PaxSegmentType
     */
    public function setPaxSegmentID($paxSegmentID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentID) && !is_string($paxSegmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentID, true), gettype($paxSegmentID)), __LINE__);
        }
        $this->PaxSegmentID = $paxSegmentID;
        return $this;
    }
    /**
     * Get CabinTypeAssociationChoice value
     * @return \StructType\CabinTypeAssociationChoiceType|null
     */
    public function getCabinTypeAssociationChoice()
    {
        return $this->CabinTypeAssociationChoice;
    }
    /**
     * Set CabinTypeAssociationChoice value
     * @param \StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice
     * @return \StructType\PaxSegmentType
     */
    public function setCabinTypeAssociationChoice(\StructType\CabinTypeAssociationChoiceType $cabinTypeAssociationChoice = null)
    {
        $this->CabinTypeAssociationChoice = $cabinTypeAssociationChoice;
        return $this;
    }
    /**
     * Get MarketingCarrierRBD_Code value
     * @return string|null
     */
    public function getMarketingCarrierRBD_Code()
    {
        return $this->MarketingCarrierRBD_Code;
    }
    /**
     * Set MarketingCarrierRBD_Code value
     * @param string $marketingCarrierRBD_Code
     * @return \StructType\PaxSegmentType
     */
    public function setMarketingCarrierRBD_Code($marketingCarrierRBD_Code = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierRBD_Code) && !is_string($marketingCarrierRBD_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierRBD_Code, true), gettype($marketingCarrierRBD_Code)), __LINE__);
        }
        $this->MarketingCarrierRBD_Code = $marketingCarrierRBD_Code;
        return $this;
    }
    /**
     * Get OperatingCarrierRBD_Code value
     * @return string|null
     */
    public function getOperatingCarrierRBD_Code()
    {
        return $this->OperatingCarrierRBD_Code;
    }
    /**
     * Set OperatingCarrierRBD_Code value
     * @param string $operatingCarrierRBD_Code
     * @return \StructType\PaxSegmentType
     */
    public function setOperatingCarrierRBD_Code($operatingCarrierRBD_Code = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierRBD_Code) && !is_string($operatingCarrierRBD_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierRBD_Code, true), gettype($operatingCarrierRBD_Code)), __LINE__);
        }
        $this->OperatingCarrierRBD_Code = $operatingCarrierRBD_Code;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * Set SettlementInfo value
     * @param \StructType\SettlementInfoType $settlementInfo
     * @return \StructType\PaxSegmentType
     */
    public function setSettlementInfo(\StructType\SettlementInfoType $settlementInfo = null)
    {
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
}
