<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxJourneyListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Journey data list definition.
 * @subpackage Structs
 */
class PaxJourneyListType extends AbstractStructBase
{
    /**
     * The PaxJourney
     * Meta information extracted from the WSDL
     * - documentation: A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier available)
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PaxJourneyType[]
     */
    public $PaxJourney;
    /**
     * Constructor method for PaxJourneyListType
     * @uses PaxJourneyListType::setPaxJourney()
     * @param \StructType\PaxJourneyType[] $paxJourney
     */
    public function __construct(array $paxJourney = array())
    {
        $this
            ->setPaxJourney($paxJourney);
    }
    /**
     * Get PaxJourney value
     * @return \StructType\PaxJourneyType[]
     */
    public function getPaxJourney()
    {
        return $this->PaxJourney;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxJourney method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxJourney method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxJourneyForArrayConstraintsFromSetPaxJourney(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxJourneyListTypePaxJourneyItem) {
            // validation for constraint: itemType
            if (!$paxJourneyListTypePaxJourneyItem instanceof \StructType\PaxJourneyType) {
                $invalidValues[] = is_object($paxJourneyListTypePaxJourneyItem) ? get_class($paxJourneyListTypePaxJourneyItem) : sprintf('%s(%s)', gettype($paxJourneyListTypePaxJourneyItem), var_export($paxJourneyListTypePaxJourneyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxJourney property can only contain items of type \StructType\PaxJourneyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxJourneyType[] $paxJourney
     * @return \StructType\PaxJourneyListType
     */
    public function setPaxJourney(array $paxJourney = array())
    {
        // validation for constraint: array
        if ('' !== ($paxJourneyArrayErrorMessage = self::validatePaxJourneyForArrayConstraintsFromSetPaxJourney($paxJourney))) {
            throw new \InvalidArgumentException($paxJourneyArrayErrorMessage, __LINE__);
        }
        $this->PaxJourney = $paxJourney;
        return $this;
    }
    /**
     * Add item to PaxJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxJourneyType $item
     * @return \StructType\PaxJourneyListType
     */
    public function addToPaxJourney(\StructType\PaxJourneyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxJourneyType) {
            throw new \InvalidArgumentException(sprintf('The PaxJourney property can only contain items of type \StructType\PaxJourneyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxJourney[] = $item;
        return $this;
    }
}
