<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTC_OfferParametersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Passenger Type summary information for an offer.
 * @subpackage Structs
 */
class PTC_OfferParametersType extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the passengers who are elibigle for this Offer Item | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PricedPaxNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of Passenger(s) for associated passenger type. Example: 2 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PricedPaxNumber;
    /**
     * The PTC_PricedCode
     * Meta information extracted from the WSDL
     * - documentation: Actual passenger type code used for pricing. Example: ADT | Additional BDT to specify the type code codeset applying to a Passenger.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PTC_PricedCode;
    /**
     * The PTC_RequestedCode
     * Meta information extracted from the WSDL
     * - documentation: Requested passenger type code for pricing. Example: CHD Encoding scheme: IATA (three character) Passenger Type Code | Additional BDT to specify the type code codeset applying to a Passenger.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PTC_RequestedCode;
    /**
     * The RequestedPaxNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of Passenger(s) for associated passenger type. Example: 2 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $RequestedPaxNumber;
    /**
     * Constructor method for PTC_OfferParametersType
     * @uses PTC_OfferParametersType::setPaxRefID()
     * @uses PTC_OfferParametersType::setPricedPaxNumber()
     * @uses PTC_OfferParametersType::setPTC_PricedCode()
     * @uses PTC_OfferParametersType::setPTC_RequestedCode()
     * @uses PTC_OfferParametersType::setRequestedPaxNumber()
     * @param string[] $paxRefID
     * @param float $pricedPaxNumber
     * @param string $pTC_PricedCode
     * @param string $pTC_RequestedCode
     * @param float $requestedPaxNumber
     */
    public function __construct(array $paxRefID = array(), $pricedPaxNumber = null, $pTC_PricedCode = null, $pTC_RequestedCode = null, $requestedPaxNumber = null)
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setPricedPaxNumber($pricedPaxNumber)
            ->setPTC_PricedCode($pTC_PricedCode)
            ->setPTC_RequestedCode($pTC_RequestedCode)
            ->setRequestedPaxNumber($requestedPaxNumber);
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pTC_OfferParametersTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($pTC_OfferParametersTypePaxRefIDItem)) {
                $invalidValues[] = is_object($pTC_OfferParametersTypePaxRefIDItem) ? get_class($pTC_OfferParametersTypePaxRefIDItem) : sprintf('%s(%s)', gettype($pTC_OfferParametersTypePaxRefIDItem), var_export($pTC_OfferParametersTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\PTC_OfferParametersType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PTC_OfferParametersType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PricedPaxNumber value
     * @return float|null
     */
    public function getPricedPaxNumber()
    {
        return $this->PricedPaxNumber;
    }
    /**
     * Set PricedPaxNumber value
     * @param float $pricedPaxNumber
     * @return \StructType\PTC_OfferParametersType
     */
    public function setPricedPaxNumber($pricedPaxNumber = null)
    {
        // validation for constraint: float
        if (!is_null($pricedPaxNumber) && !(is_float($pricedPaxNumber) || is_numeric($pricedPaxNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricedPaxNumber, true), gettype($pricedPaxNumber)), __LINE__);
        }
        $this->PricedPaxNumber = $pricedPaxNumber;
        return $this;
    }
    /**
     * Get PTC_PricedCode value
     * @return string|null
     */
    public function getPTC_PricedCode()
    {
        return $this->PTC_PricedCode;
    }
    /**
     * Set PTC_PricedCode value
     * @param string $pTC_PricedCode
     * @return \StructType\PTC_OfferParametersType
     */
    public function setPTC_PricedCode($pTC_PricedCode = null)
    {
        // validation for constraint: string
        if (!is_null($pTC_PricedCode) && !is_string($pTC_PricedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTC_PricedCode, true), gettype($pTC_PricedCode)), __LINE__);
        }
        $this->PTC_PricedCode = $pTC_PricedCode;
        return $this;
    }
    /**
     * Get PTC_RequestedCode value
     * @return string|null
     */
    public function getPTC_RequestedCode()
    {
        return $this->PTC_RequestedCode;
    }
    /**
     * Set PTC_RequestedCode value
     * @param string $pTC_RequestedCode
     * @return \StructType\PTC_OfferParametersType
     */
    public function setPTC_RequestedCode($pTC_RequestedCode = null)
    {
        // validation for constraint: string
        if (!is_null($pTC_RequestedCode) && !is_string($pTC_RequestedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTC_RequestedCode, true), gettype($pTC_RequestedCode)), __LINE__);
        }
        $this->PTC_RequestedCode = $pTC_RequestedCode;
        return $this;
    }
    /**
     * Get RequestedPaxNumber value
     * @return float|null
     */
    public function getRequestedPaxNumber()
    {
        return $this->RequestedPaxNumber;
    }
    /**
     * Set RequestedPaxNumber value
     * @param float $requestedPaxNumber
     * @return \StructType\PTC_OfferParametersType
     */
    public function setRequestedPaxNumber($requestedPaxNumber = null)
    {
        // validation for constraint: float
        if (!is_null($requestedPaxNumber) && !(is_float($requestedPaxNumber) || is_numeric($requestedPaxNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedPaxNumber, true), gettype($requestedPaxNumber)), __LINE__);
        }
        $this->RequestedPaxNumber = $requestedPaxNumber;
        return $this;
    }
}
