<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherServiceInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline code.Example: AA | Action code. Example: HK | Other service informational group.Traveler association is specified with the PaxRefID.If a traveler association number is not included, then the OSI applies to all travelers.
 * @subpackage Structs
 */
class OtherServiceInformation extends AbstractStructBase
{
    /**
     * The ActionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ActionCode
     * @var string
     */
    public $ActionCode;
    /**
     * The AirlineCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code. Example: AA
     * - base: xs:string
     * - minOccurs: 0
     * - ref: AirlineCode
     * @var string
     */
    public $AirlineCode;
    /**
     * The OSICode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OSICode
     * @var string
     */
    public $OSICode;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - ref: Text
     * @var string
     */
    public $Text;
    /**
     * Constructor method for OtherServiceInformation
     * @uses OtherServiceInformation::setActionCode()
     * @uses OtherServiceInformation::setAirlineCode()
     * @uses OtherServiceInformation::setOSICode()
     * @uses OtherServiceInformation::setText()
     * @param string $actionCode
     * @param string $airlineCode
     * @param string $oSICode
     * @param string $text
     */
    public function __construct($actionCode = null, $airlineCode = null, $oSICode = null, $text = null)
    {
        $this
            ->setActionCode($actionCode)
            ->setAirlineCode($airlineCode)
            ->setOSICode($oSICode)
            ->setText($text);
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \StructType\OtherServiceInformation
     */
    public function setActionCode($actionCode = null)
    {
        // validation for constraint: string
        if (!is_null($actionCode) && !is_string($actionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionCode, true), gettype($actionCode)), __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \StructType\OtherServiceInformation
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineCode, true), gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get OSICode value
     * @return string|null
     */
    public function getOSICode()
    {
        return $this->OSICode;
    }
    /**
     * Set OSICode value
     * @param string $oSICode
     * @return \StructType\OtherServiceInformation
     */
    public function setOSICode($oSICode = null)
    {
        // validation for constraint: string
        if (!is_null($oSICode) && !is_string($oSICode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oSICode, true), gettype($oSICode)), __LINE__);
        }
        $this->OSICode = $oSICode;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\OtherServiceInformation
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
}
