<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginalOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Original Order Item price which was repriced.
 * @subpackage Structs
 */
class OriginalOrderItemType extends AbstractStructBase
{
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $TotalPrice;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Original Order Item Reference Identifier | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderItemRefID;
    /**
     * Constructor method for OriginalOrderItemType
     * @uses OriginalOrderItemType::setTotalPrice()
     * @uses OriginalOrderItemType::setFareDetail()
     * @uses OriginalOrderItemType::setOrderItemRefID()
     * @param \StructType\PriceType $totalPrice
     * @param \StructType\FareDetailType[] $fareDetail
     * @param string $orderItemRefID
     */
    public function __construct(\StructType\PriceType $totalPrice = null, array $fareDetail = array(), $orderItemRefID = null)
    {
        $this
            ->setTotalPrice($totalPrice)
            ->setFareDetail($fareDetail)
            ->setOrderItemRefID($orderItemRefID);
    }
    /**
     * Get TotalPrice value
     * @return \StructType\PriceType
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\PriceType $totalPrice
     * @return \StructType\OriginalOrderItemType
     */
    public function setTotalPrice(\StructType\PriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $originalOrderItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$originalOrderItemTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($originalOrderItemTypeFareDetailItem) ? get_class($originalOrderItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($originalOrderItemTypeFareDetailItem), var_export($originalOrderItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\OriginalOrderItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\OriginalOrderItemType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string|null
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\OriginalOrderItemType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
}
