<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
 * @subpackage Structs
 */
class OriginDestCriteriaType extends AbstractStructBase
{
    /**
     * The DestArrivalCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Customer's requested Destination arrival time and location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DestArrivalCriteriaType
     */
    public $DestArrivalCriteria;
    /**
     * The OriginDepCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Customer's requested Origin departure time and location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OriginDepCriteriaType
     */
    public $OriginDepCriteria;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Shopping Request specialisation of Cabin Type base type definition: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestCabinTypeType[]
     */
    public $CabinType;
    /**
     * The CalendarDateCriteria
     * Meta information extracted from the WSDL
     * - documentation: Requests the airline to additionally include a preview of the Offer price for the same Shopping Criteria for the specified date range.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CalendarDateCriteriaType
     */
    public $CalendarDateCriteria;
    /**
     * The ConnectionCriteriaRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a unique identifier assigned to this transfer preference. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionCriteriaRefID;
    /**
     * The JourneyDurationCriteria
     * Meta information extracted from the WSDL
     * - documentation: Total journey travel time per bound preferences. This includes the sum of all flight durations as well as connection times.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JourneyDurationCriteriaType
     */
    public $JourneyDurationCriteria;
    /**
     * The OriginDestID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies an Origin Destination within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginDestID;
    /**
     * Constructor method for OriginDestCriteriaType
     * @uses OriginDestCriteriaType::setDestArrivalCriteria()
     * @uses OriginDestCriteriaType::setOriginDepCriteria()
     * @uses OriginDestCriteriaType::setCabinType()
     * @uses OriginDestCriteriaType::setCalendarDateCriteria()
     * @uses OriginDestCriteriaType::setConnectionCriteriaRefID()
     * @uses OriginDestCriteriaType::setJourneyDurationCriteria()
     * @uses OriginDestCriteriaType::setOriginDestID()
     * @param \StructType\DestArrivalCriteriaType $destArrivalCriteria
     * @param \StructType\OriginDepCriteriaType $originDepCriteria
     * @param \StructType\ShoppingRequestCabinTypeType[] $cabinType
     * @param \StructType\CalendarDateCriteriaType $calendarDateCriteria
     * @param string $connectionCriteriaRefID
     * @param \StructType\JourneyDurationCriteriaType $journeyDurationCriteria
     * @param string $originDestID
     */
    public function __construct(\StructType\DestArrivalCriteriaType $destArrivalCriteria = null, \StructType\OriginDepCriteriaType $originDepCriteria = null, array $cabinType = array(), \StructType\CalendarDateCriteriaType $calendarDateCriteria = null, $connectionCriteriaRefID = null, \StructType\JourneyDurationCriteriaType $journeyDurationCriteria = null, $originDestID = null)
    {
        $this
            ->setDestArrivalCriteria($destArrivalCriteria)
            ->setOriginDepCriteria($originDepCriteria)
            ->setCabinType($cabinType)
            ->setCalendarDateCriteria($calendarDateCriteria)
            ->setConnectionCriteriaRefID($connectionCriteriaRefID)
            ->setJourneyDurationCriteria($journeyDurationCriteria)
            ->setOriginDestID($originDestID);
    }
    /**
     * Get DestArrivalCriteria value
     * @return \StructType\DestArrivalCriteriaType
     */
    public function getDestArrivalCriteria()
    {
        return $this->DestArrivalCriteria;
    }
    /**
     * Set DestArrivalCriteria value
     * @param \StructType\DestArrivalCriteriaType $destArrivalCriteria
     * @return \StructType\OriginDestCriteriaType
     */
    public function setDestArrivalCriteria(\StructType\DestArrivalCriteriaType $destArrivalCriteria = null)
    {
        $this->DestArrivalCriteria = $destArrivalCriteria;
        return $this;
    }
    /**
     * Get OriginDepCriteria value
     * @return \StructType\OriginDepCriteriaType
     */
    public function getOriginDepCriteria()
    {
        return $this->OriginDepCriteria;
    }
    /**
     * Set OriginDepCriteria value
     * @param \StructType\OriginDepCriteriaType $originDepCriteria
     * @return \StructType\OriginDestCriteriaType
     */
    public function setOriginDepCriteria(\StructType\OriginDepCriteriaType $originDepCriteria = null)
    {
        $this->OriginDepCriteria = $originDepCriteria;
        return $this;
    }
    /**
     * Get CabinType value
     * @return \StructType\ShoppingRequestCabinTypeType[]|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinTypeForArrayConstraintsFromSetCabinType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $originDestCriteriaTypeCabinTypeItem) {
            // validation for constraint: itemType
            if (!$originDestCriteriaTypeCabinTypeItem instanceof \StructType\ShoppingRequestCabinTypeType) {
                $invalidValues[] = is_object($originDestCriteriaTypeCabinTypeItem) ? get_class($originDestCriteriaTypeCabinTypeItem) : sprintf('%s(%s)', gettype($originDestCriteriaTypeCabinTypeItem), var_export($originDestCriteriaTypeCabinTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinType property can only contain items of type \StructType\ShoppingRequestCabinTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestCabinTypeType[] $cabinType
     * @return \StructType\OriginDestCriteriaType
     */
    public function setCabinType(array $cabinType = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinTypeArrayErrorMessage = self::validateCabinTypeForArrayConstraintsFromSetCabinType($cabinType))) {
            throw new \InvalidArgumentException($cabinTypeArrayErrorMessage, __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Add item to CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestCabinTypeType $item
     * @return \StructType\OriginDestCriteriaType
     */
    public function addToCabinType(\StructType\ShoppingRequestCabinTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingRequestCabinTypeType) {
            throw new \InvalidArgumentException(sprintf('The CabinType property can only contain items of type \StructType\ShoppingRequestCabinTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinType[] = $item;
        return $this;
    }
    /**
     * Get CalendarDateCriteria value
     * @return \StructType\CalendarDateCriteriaType|null
     */
    public function getCalendarDateCriteria()
    {
        return $this->CalendarDateCriteria;
    }
    /**
     * Set CalendarDateCriteria value
     * @param \StructType\CalendarDateCriteriaType $calendarDateCriteria
     * @return \StructType\OriginDestCriteriaType
     */
    public function setCalendarDateCriteria(\StructType\CalendarDateCriteriaType $calendarDateCriteria = null)
    {
        $this->CalendarDateCriteria = $calendarDateCriteria;
        return $this;
    }
    /**
     * Get ConnectionCriteriaRefID value
     * @return string|null
     */
    public function getConnectionCriteriaRefID()
    {
        return $this->ConnectionCriteriaRefID;
    }
    /**
     * Set ConnectionCriteriaRefID value
     * @param string $connectionCriteriaRefID
     * @return \StructType\OriginDestCriteriaType
     */
    public function setConnectionCriteriaRefID($connectionCriteriaRefID = null)
    {
        // validation for constraint: string
        if (!is_null($connectionCriteriaRefID) && !is_string($connectionCriteriaRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionCriteriaRefID, true), gettype($connectionCriteriaRefID)), __LINE__);
        }
        $this->ConnectionCriteriaRefID = $connectionCriteriaRefID;
        return $this;
    }
    /**
     * Get JourneyDurationCriteria value
     * @return \StructType\JourneyDurationCriteriaType|null
     */
    public function getJourneyDurationCriteria()
    {
        return $this->JourneyDurationCriteria;
    }
    /**
     * Set JourneyDurationCriteria value
     * @param \StructType\JourneyDurationCriteriaType $journeyDurationCriteria
     * @return \StructType\OriginDestCriteriaType
     */
    public function setJourneyDurationCriteria(\StructType\JourneyDurationCriteriaType $journeyDurationCriteria = null)
    {
        $this->JourneyDurationCriteria = $journeyDurationCriteria;
        return $this;
    }
    /**
     * Get OriginDestID value
     * @return string|null
     */
    public function getOriginDestID()
    {
        return $this->OriginDestID;
    }
    /**
     * Set OriginDestID value
     * @param string $originDestID
     * @return \StructType\OriginDestCriteriaType
     */
    public function setOriginDestID($originDestID = null)
    {
        // validation for constraint: string
        if (!is_null($originDestID) && !is_string($originDestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDestID, true), gettype($originDestID)), __LINE__);
        }
        $this->OriginDestID = $originDestID;
        return $this;
    }
}
