<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderedOrderInstructionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Ordered Order Instruction
 * @subpackage Structs
 */
class OrderedOrderInstructionType extends AbstractStructBase
{
    /**
     * The CabinTypeList
     * Meta information extracted from the WSDL
     * - documentation: List of Cabin Types Technical object only
     * - choice: CabinTypeList | SpecialServiceList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CabinTypeListType
     */
    public $CabinTypeList;
    /**
     * The SpecialServiceList
     * Meta information extracted from the WSDL
     * - documentation: List of Special service types. Technical object only
     * - choice: CabinTypeList | SpecialServiceList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SpecialServiceListType
     */
    public $SpecialServiceList;
    /**
     * Constructor method for OrderedOrderInstructionType
     * @uses OrderedOrderInstructionType::setCabinTypeList()
     * @uses OrderedOrderInstructionType::setSpecialServiceList()
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @param \StructType\SpecialServiceListType $specialServiceList
     */
    public function __construct(\StructType\CabinTypeListType $cabinTypeList = null, \StructType\SpecialServiceListType $specialServiceList = null)
    {
        $this
            ->setCabinTypeList($cabinTypeList)
            ->setSpecialServiceList($specialServiceList);
    }
    /**
     * Get CabinTypeList value
     * @return \StructType\CabinTypeListType
     */
    public function getCabinTypeList()
    {
        return isset($this->CabinTypeList) ? $this->CabinTypeList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCabinTypeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinTypeList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCabinTypeListForChoiceConstraintsFromSetCabinTypeList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SpecialServiceList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CabinTypeList can\'t be set as the property %s is already set. Only one property must be set among these properties: CabinTypeList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CabinTypeList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @return \StructType\OrderedOrderInstructionType
     */
    public function setCabinTypeList(\StructType\CabinTypeListType $cabinTypeList = null)
    {
        // validation for constraint: choice(CabinTypeList, SpecialServiceList)
        if ('' !== ($cabinTypeListChoiceErrorMessage = self::validateCabinTypeListForChoiceConstraintsFromSetCabinTypeList($cabinTypeList))) {
            throw new \InvalidArgumentException($cabinTypeListChoiceErrorMessage, __LINE__);
        }
        if (is_null($cabinTypeList) || (is_array($cabinTypeList) && empty($cabinTypeList))) {
            unset($this->CabinTypeList);
        } else {
            $this->CabinTypeList = $cabinTypeList;
        }
        return $this;
    }
    /**
     * Get SpecialServiceList value
     * @return \StructType\SpecialServiceListType
     */
    public function getSpecialServiceList()
    {
        return isset($this->SpecialServiceList) ? $this->SpecialServiceList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSpecialServiceList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialServiceList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSpecialServiceListForChoiceConstraintsFromSetSpecialServiceList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CabinTypeList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SpecialServiceList can\'t be set as the property %s is already set. Only one property must be set among these properties: SpecialServiceList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SpecialServiceList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceListType $specialServiceList
     * @return \StructType\OrderedOrderInstructionType
     */
    public function setSpecialServiceList(\StructType\SpecialServiceListType $specialServiceList = null)
    {
        // validation for constraint: choice(CabinTypeList, SpecialServiceList)
        if ('' !== ($specialServiceListChoiceErrorMessage = self::validateSpecialServiceListForChoiceConstraintsFromSetSpecialServiceList($specialServiceList))) {
            throw new \InvalidArgumentException($specialServiceListChoiceErrorMessage, __LINE__);
        }
        if (is_null($specialServiceList) || (is_array($specialServiceList) && empty($specialServiceList))) {
            unset($this->SpecialServiceList);
        } else {
            $this->SpecialServiceList = $specialServiceList;
        }
        return $this;
    }
}
