<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderSnapshotType StructType
 * Meta information extracted from the WSDL
 * - documentation: Version of the Order to which the change operations above need to be applied. Once fully updated, the version of the Order would correspond to the version of the last ChangeGroup in this batch of changes (OrderChangeNotifRQ).
 * Required by Sellers who are unable to store the Orders sent to them by Airlines. Also used by Airlines unable to persist IDs or reproduce IDs consistently between Order responses.
 * @subpackage Structs
 */
class OrderSnapshotType extends AbstractStructBase
{
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderedOrderType[]
     */
    public $Order;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsOrderType[]
     */
    public $PaymentFunctions;
    /**
     * The TicketDocInfo
     * Meta information extracted from the WSDL
     * - documentation: Information corresponding to a group of 1 to 4 Tickets for a single Origin Destination and a single Passenger.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TicketDocInfoType[]
     */
    public $TicketDocInfo;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for OrderSnapshotType
     * @uses OrderSnapshotType::setDataLists()
     * @uses OrderSnapshotType::setOrder()
     * @uses OrderSnapshotType::setPaymentFunctions()
     * @uses OrderSnapshotType::setTicketDocInfo()
     * @uses OrderSnapshotType::setWarning()
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\OrderedOrderType[] $order
     * @param \StructType\PaymentFunctionsOrderType[] $paymentFunctions
     * @param \StructType\TicketDocInfoType[] $ticketDocInfo
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(\StructType\DataListsType $dataLists = null, array $order = array(), array $paymentFunctions = array(), array $ticketDocInfo = array(), array $warning = array())
    {
        $this
            ->setDataLists($dataLists)
            ->setOrder($order)
            ->setPaymentFunctions($paymentFunctions)
            ->setTicketDocInfo($ticketDocInfo)
            ->setWarning($warning);
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\OrderSnapshotType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderedOrderType[]|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSnapshotTypeOrderItem) {
            // validation for constraint: itemType
            if (!$orderSnapshotTypeOrderItem instanceof \StructType\OrderedOrderType) {
                $invalidValues[] = is_object($orderSnapshotTypeOrderItem) ? get_class($orderSnapshotTypeOrderItem) : sprintf('%s(%s)', gettype($orderSnapshotTypeOrderItem), var_export($orderSnapshotTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\OrderedOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderedOrderType[] $order
     * @return \StructType\OrderSnapshotType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderedOrderType $item
     * @return \StructType\OrderSnapshotType
     */
    public function addToOrder(\StructType\OrderedOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderedOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\OrderedOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsOrderType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSnapshotTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$orderSnapshotTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsOrderType) {
                $invalidValues[] = is_object($orderSnapshotTypePaymentFunctionsItem) ? get_class($orderSnapshotTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($orderSnapshotTypePaymentFunctionsItem), var_export($orderSnapshotTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOrderType[] $paymentFunctions
     * @return \StructType\OrderSnapshotType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOrderType $item
     * @return \StructType\OrderSnapshotType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsOrderType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get TicketDocInfo value
     * @return \StructType\TicketDocInfoType[]|null
     */
    public function getTicketDocInfo()
    {
        return $this->TicketDocInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDocInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDocInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDocInfoForArrayConstraintsFromSetTicketDocInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSnapshotTypeTicketDocInfoItem) {
            // validation for constraint: itemType
            if (!$orderSnapshotTypeTicketDocInfoItem instanceof \StructType\TicketDocInfoType) {
                $invalidValues[] = is_object($orderSnapshotTypeTicketDocInfoItem) ? get_class($orderSnapshotTypeTicketDocInfoItem) : sprintf('%s(%s)', gettype($orderSnapshotTypeTicketDocInfoItem), var_export($orderSnapshotTypeTicketDocInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDocInfo property can only contain items of type \StructType\TicketDocInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDocInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocInfoType[] $ticketDocInfo
     * @return \StructType\OrderSnapshotType
     */
    public function setTicketDocInfo(array $ticketDocInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDocInfoArrayErrorMessage = self::validateTicketDocInfoForArrayConstraintsFromSetTicketDocInfo($ticketDocInfo))) {
            throw new \InvalidArgumentException($ticketDocInfoArrayErrorMessage, __LINE__);
        }
        $this->TicketDocInfo = $ticketDocInfo;
        return $this;
    }
    /**
     * Add item to TicketDocInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocInfoType $item
     * @return \StructType\OrderSnapshotType
     */
    public function addToTicketDocInfo(\StructType\TicketDocInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDocInfoType) {
            throw new \InvalidArgumentException(sprintf('The TicketDocInfo property can only contain items of type \StructType\TicketDocInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDocInfo[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSnapshotTypeWarningItem) {
            // validation for constraint: itemType
            if (!$orderSnapshotTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($orderSnapshotTypeWarningItem) ? get_class($orderSnapshotTypeWarningItem) : sprintf('%s(%s)', gettype($orderSnapshotTypeWarningItem), var_export($orderSnapshotTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\OrderSnapshotType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\OrderSnapshotType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
