<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReshopRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Reshop message
 * @subpackage Structs
 */
class OrderReshopRequestType extends AbstractStructBase
{
    /**
     * The OrderRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Order to which the Seller wants to add, update or delete an Order Item. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is
     * managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderRefID;
    /**
     * The UpdateOrder
     * Meta information extracted from the WSDL
     * - documentation: Update Order
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\UpdateOrderType
     */
    public $UpdateOrder;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType
     */
    public $DatedOperatingSegmentList;
    /**
     * The DisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Disclosure data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DisclosureListType[]
     */
    public $DisclosureList;
    /**
     * The FareWaiver
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier-assigned fare rule modification or override information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareWaiverType[]
     */
    public $FareWaiver;
    /**
     * The PaxJourneyList
     * Meta information extracted from the WSDL
     * - documentation: Journey data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestPaxJourneyListType
     */
    public $PaxJourneyList;
    /**
     * The PayloadRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Enables restriction of message payloads for selected objects.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PayloadRestrictionsType[]
     */
    public $PayloadRestrictions;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Criteria Specialization of Payment Functions: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentAssociatedFunctionsCriteriaType[]
     */
    public $PaymentFunctions;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for OrderReshopRequestType
     * @uses OrderReshopRequestType::setOrderRefID()
     * @uses OrderReshopRequestType::setUpdateOrder()
     * @uses OrderReshopRequestType::setBookingRef()
     * @uses OrderReshopRequestType::setContactInfoList()
     * @uses OrderReshopRequestType::setDatedMarketingSegmentList()
     * @uses OrderReshopRequestType::setDatedOperatingLegList()
     * @uses OrderReshopRequestType::setDatedOperatingSegmentList()
     * @uses OrderReshopRequestType::setDisclosureList()
     * @uses OrderReshopRequestType::setFareWaiver()
     * @uses OrderReshopRequestType::setPaxJourneyList()
     * @uses OrderReshopRequestType::setPayloadRestrictions()
     * @uses OrderReshopRequestType::setPaymentFunctions()
     * @uses OrderReshopRequestType::setResponseParameters()
     * @param string $orderRefID
     * @param \StructType\UpdateOrderType $updateOrder
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @param \StructType\DisclosureListType[] $disclosureList
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @param \StructType\ShoppingRequestPaxJourneyListType $paxJourneyList
     * @param \StructType\PayloadRestrictionsType[] $payloadRestrictions
     * @param \StructType\PaymentAssociatedFunctionsCriteriaType[] $paymentFunctions
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct($orderRefID = null, \StructType\UpdateOrderType $updateOrder = null, array $bookingRef = array(), array $contactInfoList = array(), \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null, \StructType\DatedOperatingLegListType $datedOperatingLegList = null, \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null, array $disclosureList = array(), array $fareWaiver = array(), \StructType\ShoppingRequestPaxJourneyListType $paxJourneyList = null, array $payloadRestrictions = array(), array $paymentFunctions = array(), \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setOrderRefID($orderRefID)
            ->setUpdateOrder($updateOrder)
            ->setBookingRef($bookingRef)
            ->setContactInfoList($contactInfoList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setDisclosureList($disclosureList)
            ->setFareWaiver($fareWaiver)
            ->setPaxJourneyList($paxJourneyList)
            ->setPayloadRestrictions($payloadRestrictions)
            ->setPaymentFunctions($paymentFunctions)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get OrderRefID value
     * @return string
     */
    public function getOrderRefID()
    {
        return $this->OrderRefID;
    }
    /**
     * Set OrderRefID value
     * @param string $orderRefID
     * @return \StructType\OrderReshopRequestType
     */
    public function setOrderRefID($orderRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderRefID) && !is_string($orderRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderRefID, true), gettype($orderRefID)), __LINE__);
        }
        $this->OrderRefID = $orderRefID;
        return $this;
    }
    /**
     * Get UpdateOrder value
     * @return \StructType\UpdateOrderType
     */
    public function getUpdateOrder()
    {
        return $this->UpdateOrder;
    }
    /**
     * Set UpdateOrder value
     * @param \StructType\UpdateOrderType $updateOrder
     * @return \StructType\OrderReshopRequestType
     */
    public function setUpdateOrder(\StructType\UpdateOrderType $updateOrder = null)
    {
        $this->UpdateOrder = $updateOrder;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopRequestTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$orderReshopRequestTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($orderReshopRequestTypeBookingRefItem) ? get_class($orderReshopRequestTypeBookingRefItem) : sprintf('%s(%s)', gettype($orderReshopRequestTypeBookingRefItem), var_export($orderReshopRequestTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\OrderReshopRequestType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\OrderReshopRequestType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopRequestTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$orderReshopRequestTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($orderReshopRequestTypeContactInfoListItem) ? get_class($orderReshopRequestTypeContactInfoListItem) : sprintf('%s(%s)', gettype($orderReshopRequestTypeContactInfoListItem), var_export($orderReshopRequestTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\OrderReshopRequestType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\OrderReshopRequestType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @return \StructType\OrderReshopRequestType
     */
    public function setDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null)
    {
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * Set DatedOperatingLegList value
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @return \StructType\OrderReshopRequestType
     */
    public function setDatedOperatingLegList(\StructType\DatedOperatingLegListType $datedOperatingLegList = null)
    {
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @return \StructType\OrderReshopRequestType
     */
    public function setDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null)
    {
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Get DisclosureList value
     * @return \StructType\DisclosureListType[]|null
     */
    public function getDisclosureList()
    {
        return $this->DisclosureList;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclosureList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclosureList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclosureListForArrayConstraintsFromSetDisclosureList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopRequestTypeDisclosureListItem) {
            // validation for constraint: itemType
            if (!$orderReshopRequestTypeDisclosureListItem instanceof \StructType\DisclosureListType) {
                $invalidValues[] = is_object($orderReshopRequestTypeDisclosureListItem) ? get_class($orderReshopRequestTypeDisclosureListItem) : sprintf('%s(%s)', gettype($orderReshopRequestTypeDisclosureListItem), var_export($orderReshopRequestTypeDisclosureListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DisclosureList property can only contain items of type \StructType\DisclosureListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DisclosureList value
     * @throws \InvalidArgumentException
     * @param \StructType\DisclosureListType[] $disclosureList
     * @return \StructType\OrderReshopRequestType
     */
    public function setDisclosureList(array $disclosureList = array())
    {
        // validation for constraint: array
        if ('' !== ($disclosureListArrayErrorMessage = self::validateDisclosureListForArrayConstraintsFromSetDisclosureList($disclosureList))) {
            throw new \InvalidArgumentException($disclosureListArrayErrorMessage, __LINE__);
        }
        $this->DisclosureList = $disclosureList;
        return $this;
    }
    /**
     * Add item to DisclosureList value
     * @throws \InvalidArgumentException
     * @param \StructType\DisclosureListType $item
     * @return \StructType\OrderReshopRequestType
     */
    public function addToDisclosureList(\StructType\DisclosureListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DisclosureListType) {
            throw new \InvalidArgumentException(sprintf('The DisclosureList property can only contain items of type \StructType\DisclosureListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DisclosureList[] = $item;
        return $this;
    }
    /**
     * Get FareWaiver value
     * @return \StructType\FareWaiverType[]|null
     */
    public function getFareWaiver()
    {
        return $this->FareWaiver;
    }
    /**
     * This method is responsible for validating the values passed to the setFareWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareWaiverForArrayConstraintsFromSetFareWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopRequestTypeFareWaiverItem) {
            // validation for constraint: itemType
            if (!$orderReshopRequestTypeFareWaiverItem instanceof \StructType\FareWaiverType) {
                $invalidValues[] = is_object($orderReshopRequestTypeFareWaiverItem) ? get_class($orderReshopRequestTypeFareWaiverItem) : sprintf('%s(%s)', gettype($orderReshopRequestTypeFareWaiverItem), var_export($orderReshopRequestTypeFareWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @return \StructType\OrderReshopRequestType
     */
    public function setFareWaiver(array $fareWaiver = array())
    {
        // validation for constraint: array
        if ('' !== ($fareWaiverArrayErrorMessage = self::validateFareWaiverForArrayConstraintsFromSetFareWaiver($fareWaiver))) {
            throw new \InvalidArgumentException($fareWaiverArrayErrorMessage, __LINE__);
        }
        $this->FareWaiver = $fareWaiver;
        return $this;
    }
    /**
     * Add item to FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType $item
     * @return \StructType\OrderReshopRequestType
     */
    public function addToFareWaiver(\StructType\FareWaiverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareWaiverType) {
            throw new \InvalidArgumentException(sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareWaiver[] = $item;
        return $this;
    }
    /**
     * Get PaxJourneyList value
     * @return \StructType\ShoppingRequestPaxJourneyListType|null
     */
    public function getPaxJourneyList()
    {
        return $this->PaxJourneyList;
    }
    /**
     * Set PaxJourneyList value
     * @param \StructType\ShoppingRequestPaxJourneyListType $paxJourneyList
     * @return \StructType\OrderReshopRequestType
     */
    public function setPaxJourneyList(\StructType\ShoppingRequestPaxJourneyListType $paxJourneyList = null)
    {
        $this->PaxJourneyList = $paxJourneyList;
        return $this;
    }
    /**
     * Get PayloadRestrictions value
     * @return \StructType\PayloadRestrictionsType[]|null
     */
    public function getPayloadRestrictions()
    {
        return $this->PayloadRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setPayloadRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayloadRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayloadRestrictionsForArrayConstraintsFromSetPayloadRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopRequestTypePayloadRestrictionsItem) {
            // validation for constraint: itemType
            if (!$orderReshopRequestTypePayloadRestrictionsItem instanceof \StructType\PayloadRestrictionsType) {
                $invalidValues[] = is_object($orderReshopRequestTypePayloadRestrictionsItem) ? get_class($orderReshopRequestTypePayloadRestrictionsItem) : sprintf('%s(%s)', gettype($orderReshopRequestTypePayloadRestrictionsItem), var_export($orderReshopRequestTypePayloadRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PayloadRestrictions property can only contain items of type \StructType\PayloadRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PayloadRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\PayloadRestrictionsType[] $payloadRestrictions
     * @return \StructType\OrderReshopRequestType
     */
    public function setPayloadRestrictions(array $payloadRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($payloadRestrictionsArrayErrorMessage = self::validatePayloadRestrictionsForArrayConstraintsFromSetPayloadRestrictions($payloadRestrictions))) {
            throw new \InvalidArgumentException($payloadRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->PayloadRestrictions = $payloadRestrictions;
        return $this;
    }
    /**
     * Add item to PayloadRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\PayloadRestrictionsType $item
     * @return \StructType\OrderReshopRequestType
     */
    public function addToPayloadRestrictions(\StructType\PayloadRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PayloadRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The PayloadRestrictions property can only contain items of type \StructType\PayloadRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PayloadRestrictions[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopRequestTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$orderReshopRequestTypePaymentFunctionsItem instanceof \StructType\PaymentAssociatedFunctionsCriteriaType) {
                $invalidValues[] = is_object($orderReshopRequestTypePaymentFunctionsItem) ? get_class($orderReshopRequestTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($orderReshopRequestTypePaymentFunctionsItem), var_export($orderReshopRequestTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentAssociatedFunctionsCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAssociatedFunctionsCriteriaType[] $paymentFunctions
     * @return \StructType\OrderReshopRequestType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAssociatedFunctionsCriteriaType $item
     * @return \StructType\OrderReshopRequestType
     */
    public function addToPaymentFunctions(\StructType\PaymentAssociatedFunctionsCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentAssociatedFunctionsCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentAssociatedFunctionsCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OrderReshopRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
