<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderListRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for Order List
 * @subpackage Structs
 */
class OrderListRequestType extends AbstractStructBase
{
    /**
     * The OrderSearchFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Order list request filter criteria.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderSearchFilterCriteriaType
     */
    public $OrderSearchFilterCriteria;
    /**
     * The OrderListParameters
     * Meta information extracted from the WSDL
     * - documentation: Placeholder for parameter information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderListParametersType
     */
    public $OrderListParameters;
    /**
     * Constructor method for OrderListRequestType
     * @uses OrderListRequestType::setOrderSearchFilterCriteria()
     * @uses OrderListRequestType::setOrderListParameters()
     * @param \StructType\OrderSearchFilterCriteriaType $orderSearchFilterCriteria
     * @param \StructType\OrderListParametersType $orderListParameters
     */
    public function __construct(\StructType\OrderSearchFilterCriteriaType $orderSearchFilterCriteria = null, \StructType\OrderListParametersType $orderListParameters = null)
    {
        $this
            ->setOrderSearchFilterCriteria($orderSearchFilterCriteria)
            ->setOrderListParameters($orderListParameters);
    }
    /**
     * Get OrderSearchFilterCriteria value
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function getOrderSearchFilterCriteria()
    {
        return $this->OrderSearchFilterCriteria;
    }
    /**
     * Set OrderSearchFilterCriteria value
     * @param \StructType\OrderSearchFilterCriteriaType $orderSearchFilterCriteria
     * @return \StructType\OrderListRequestType
     */
    public function setOrderSearchFilterCriteria(\StructType\OrderSearchFilterCriteriaType $orderSearchFilterCriteria = null)
    {
        $this->OrderSearchFilterCriteria = $orderSearchFilterCriteria;
        return $this;
    }
    /**
     * Get OrderListParameters value
     * @return \StructType\OrderListParametersType|null
     */
    public function getOrderListParameters()
    {
        return $this->OrderListParameters;
    }
    /**
     * Set OrderListParameters value
     * @param \StructType\OrderListParametersType $orderListParameters
     * @return \StructType\OrderListRequestType
     */
    public function setOrderListParameters(\StructType\OrderListParametersType $orderListParameters = null)
    {
        $this->OrderListParameters = $orderListParameters;
        return $this;
    }
}
