<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemDeletionOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: OrderItems which the Airline confirms can be deleted in a subsequent OrderChangeRQ. Optionally, a price differential (e.g. refund amounts) can be added to each OrderItem occurrence being deleted. Should not be used for 'replace' type
 * functions.
 * @subpackage Structs
 */
class OrderItemDeletionOfferItemType extends AbstractStructBase
{
    /**
     * The ExistingOrderItem
     * Meta information extracted from the WSDL
     * - documentation: Existing Order Item node provides information about the current and future statuses of the services in the referred Order Item, following the acceptance of the Reshopped Offer.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ExistingOrderItemType[]
     */
    public $ExistingOrderItem;
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Offer. Exceeding 64 characters or use of dashes is not recommended. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemID;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The ModificationProhibitedInd
     * Meta information extracted from the WSDL
     * - documentation: POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POA's offer ARE
     * NOT allowed. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ModificationProhibitedInd;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The PriceDifferential
     * Meta information extracted from the WSDL
     * - documentation: For each OfferItem, this function allows the airline to inform the seller about amount differential type if this OfferItem is chosen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceDifferentialType
     */
    public $PriceDifferential;
    /**
     * Constructor method for OrderItemDeletionOfferItemType
     * @uses OrderItemDeletionOfferItemType::setExistingOrderItem()
     * @uses OrderItemDeletionOfferItemType::setOfferItemID()
     * @uses OrderItemDeletionOfferItemType::setMandatoryInd()
     * @uses OrderItemDeletionOfferItemType::setModificationProhibitedInd()
     * @uses OrderItemDeletionOfferItemType::setPenaltyRefID()
     * @uses OrderItemDeletionOfferItemType::setPriceDifferential()
     * @param \StructType\ExistingOrderItemType[] $existingOrderItem
     * @param string $offerItemID
     * @param bool $mandatoryInd
     * @param bool $modificationProhibitedInd
     * @param string[] $penaltyRefID
     * @param \StructType\PriceDifferentialType $priceDifferential
     */
    public function __construct(array $existingOrderItem = array(), $offerItemID = null, $mandatoryInd = null, $modificationProhibitedInd = null, array $penaltyRefID = array(), \StructType\PriceDifferentialType $priceDifferential = null)
    {
        $this
            ->setExistingOrderItem($existingOrderItem)
            ->setOfferItemID($offerItemID)
            ->setMandatoryInd($mandatoryInd)
            ->setModificationProhibitedInd($modificationProhibitedInd)
            ->setPenaltyRefID($penaltyRefID)
            ->setPriceDifferential($priceDifferential);
    }
    /**
     * Get ExistingOrderItem value
     * @return \StructType\ExistingOrderItemType[]
     */
    public function getExistingOrderItem()
    {
        return $this->ExistingOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setExistingOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExistingOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExistingOrderItemForArrayConstraintsFromSetExistingOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemDeletionOfferItemTypeExistingOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemDeletionOfferItemTypeExistingOrderItemItem instanceof \StructType\ExistingOrderItemType) {
                $invalidValues[] = is_object($orderItemDeletionOfferItemTypeExistingOrderItemItem) ? get_class($orderItemDeletionOfferItemTypeExistingOrderItemItem) : sprintf('%s(%s)', gettype($orderItemDeletionOfferItemTypeExistingOrderItemItem), var_export($orderItemDeletionOfferItemTypeExistingOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExistingOrderItem property can only contain items of type \StructType\ExistingOrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExistingOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ExistingOrderItemType[] $existingOrderItem
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function setExistingOrderItem(array $existingOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($existingOrderItemArrayErrorMessage = self::validateExistingOrderItemForArrayConstraintsFromSetExistingOrderItem($existingOrderItem))) {
            throw new \InvalidArgumentException($existingOrderItemArrayErrorMessage, __LINE__);
        }
        $this->ExistingOrderItem = $existingOrderItem;
        return $this;
    }
    /**
     * Add item to ExistingOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ExistingOrderItemType $item
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function addToExistingOrderItem(\StructType\ExistingOrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExistingOrderItemType) {
            throw new \InvalidArgumentException(sprintf('The ExistingOrderItem property can only contain items of type \StructType\ExistingOrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExistingOrderItem[] = $item;
        return $this;
    }
    /**
     * Get OfferItemID value
     * @return string
     */
    public function getOfferItemID()
    {
        return $this->OfferItemID;
    }
    /**
     * Set OfferItemID value
     * @param string $offerItemID
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        $this->OfferItemID = $offerItemID;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get ModificationProhibitedInd value
     * @return bool|null
     */
    public function getModificationProhibitedInd()
    {
        return $this->ModificationProhibitedInd;
    }
    /**
     * Set ModificationProhibitedInd value
     * @param bool $modificationProhibitedInd
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function setModificationProhibitedInd($modificationProhibitedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($modificationProhibitedInd) && !is_bool($modificationProhibitedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modificationProhibitedInd, true), gettype($modificationProhibitedInd)), __LINE__);
        }
        $this->ModificationProhibitedInd = $modificationProhibitedInd;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemDeletionOfferItemTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($orderItemDeletionOfferItemTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($orderItemDeletionOfferItemTypePenaltyRefIDItem) ? get_class($orderItemDeletionOfferItemTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($orderItemDeletionOfferItemTypePenaltyRefIDItem), var_export($orderItemDeletionOfferItemTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get PriceDifferential value
     * @return \StructType\PriceDifferentialType|null
     */
    public function getPriceDifferential()
    {
        return $this->PriceDifferential;
    }
    /**
     * Set PriceDifferential value
     * @param \StructType\PriceDifferentialType $priceDifferential
     * @return \StructType\OrderItemDeletionOfferItemType
     */
    public function setPriceDifferential(\StructType\PriceDifferentialType $priceDifferential = null)
    {
        $this->PriceDifferential = $priceDifferential;
        return $this;
    }
}
