<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderForfeitedInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to an amount which could not be recovered as a consequence of a servicing operation.
 * @subpackage Structs
 */
class OrderForfeitedInfoType extends AbstractStructBase
{
    /**
     * The ForfeitedInfoID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the Forfeited Info | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForfeitedInfoID;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID for which may be forfeited. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Forfeited creation timestamp | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Pax ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * Constructor method for OrderForfeitedInfoType
     * @uses OrderForfeitedInfoType::setForfeitedInfoID()
     * @uses OrderForfeitedInfoType::setOrderItemRefID()
     * @uses OrderForfeitedInfoType::setPrice()
     * @uses OrderForfeitedInfoType::setCreationDateTime()
     * @uses OrderForfeitedInfoType::setPaxRefID()
     * @param string $forfeitedInfoID
     * @param string $orderItemRefID
     * @param \StructType\PriceType $price
     * @param string $creationDateTime
     * @param string $paxRefID
     */
    public function __construct($forfeitedInfoID = null, $orderItemRefID = null, \StructType\PriceType $price = null, $creationDateTime = null, $paxRefID = null)
    {
        $this
            ->setForfeitedInfoID($forfeitedInfoID)
            ->setOrderItemRefID($orderItemRefID)
            ->setPrice($price)
            ->setCreationDateTime($creationDateTime)
            ->setPaxRefID($paxRefID);
    }
    /**
     * Get ForfeitedInfoID value
     * @return string
     */
    public function getForfeitedInfoID()
    {
        return $this->ForfeitedInfoID;
    }
    /**
     * Set ForfeitedInfoID value
     * @param string $forfeitedInfoID
     * @return \StructType\OrderForfeitedInfoType
     */
    public function setForfeitedInfoID($forfeitedInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($forfeitedInfoID) && !is_string($forfeitedInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forfeitedInfoID, true), gettype($forfeitedInfoID)), __LINE__);
        }
        $this->ForfeitedInfoID = $forfeitedInfoID;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\OrderForfeitedInfoType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\OrderForfeitedInfoType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\OrderForfeitedInfoType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\OrderForfeitedInfoType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
}
