<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderFlightAssociationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Order Service Definition Ref Flight Associations
 * @subpackage Structs
 */
class OrderFlightAssociationsType extends AbstractStructBase
{
    /**
     * The DatedOperatingLegRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Dated Operating Leg within this message
     * - choice: DatedOperatingLegRef | PaxSegmentRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DatedOperatingLegRefType
     */
    public $DatedOperatingLegRef;
    /**
     * The PaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID . This will be a reference to a single passenger segment that will be defined in a data list or pax segment list in the contained message.
     * - choice: DatedOperatingLegRef | PaxSegmentRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefType
     */
    public $PaxSegmentRef;
    /**
     * Constructor method for OrderFlightAssociationsType
     * @uses OrderFlightAssociationsType::setDatedOperatingLegRef()
     * @uses OrderFlightAssociationsType::setPaxSegmentRef()
     * @param \StructType\DatedOperatingLegRefType $datedOperatingLegRef
     * @param \StructType\PaxSegmentRefType $paxSegmentRef
     */
    public function __construct(\StructType\DatedOperatingLegRefType $datedOperatingLegRef = null, \StructType\PaxSegmentRefType $paxSegmentRef = null)
    {
        $this
            ->setDatedOperatingLegRef($datedOperatingLegRef)
            ->setPaxSegmentRef($paxSegmentRef);
    }
    /**
     * Get DatedOperatingLegRef value
     * @return \StructType\DatedOperatingLegRefType
     */
    public function getDatedOperatingLegRef()
    {
        return isset($this->DatedOperatingLegRef) ? $this->DatedOperatingLegRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDatedOperatingLegRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDatedOperatingLegRefForChoiceConstraintsFromSetDatedOperatingLegRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegmentRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DatedOperatingLegRef can\'t be set as the property %s is already set. Only one property must be set among these properties: DatedOperatingLegRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DatedOperatingLegRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegRefType $datedOperatingLegRef
     * @return \StructType\OrderFlightAssociationsType
     */
    public function setDatedOperatingLegRef(\StructType\DatedOperatingLegRefType $datedOperatingLegRef = null)
    {
        // validation for constraint: choice(DatedOperatingLegRef, PaxSegmentRef)
        if ('' !== ($datedOperatingLegRefChoiceErrorMessage = self::validateDatedOperatingLegRefForChoiceConstraintsFromSetDatedOperatingLegRef($datedOperatingLegRef))) {
            throw new \InvalidArgumentException($datedOperatingLegRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($datedOperatingLegRef) || (is_array($datedOperatingLegRef) && empty($datedOperatingLegRef))) {
            unset($this->DatedOperatingLegRef);
        } else {
            $this->DatedOperatingLegRef = $datedOperatingLegRef;
        }
        return $this;
    }
    /**
     * Get PaxSegmentRef value
     * @return \StructType\PaxSegmentRefType
     */
    public function getPaxSegmentRef()
    {
        return isset($this->PaxSegmentRef) ? $this->PaxSegmentRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentRefForChoiceConstraintsFromSetPaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DatedOperatingLegRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefType $paxSegmentRef
     * @return \StructType\OrderFlightAssociationsType
     */
    public function setPaxSegmentRef(\StructType\PaxSegmentRefType $paxSegmentRef = null)
    {
        // validation for constraint: choice(DatedOperatingLegRef, PaxSegmentRef)
        if ('' !== ($paxSegmentRefChoiceErrorMessage = self::validatePaxSegmentRefForChoiceConstraintsFromSetPaxSegmentRef($paxSegmentRef))) {
            throw new \InvalidArgumentException($paxSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegmentRef) || (is_array($paxSegmentRef) && empty($paxSegmentRef))) {
            unset($this->PaxSegmentRef);
        } else {
            $this->PaxSegmentRef = $paxSegmentRef;
        }
        return $this;
    }
}
