<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderClosingNotifRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Closing Notification message
 * @subpackage Structs
 */
class OrderClosingNotifRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderKeyType
     */
    public $Order;
    /**
     * Constructor method for OrderClosingNotifRequestType
     * @uses OrderClosingNotifRequestType::setOrder()
     * @param \StructType\OrderKeyType $order
     */
    public function __construct(\StructType\OrderKeyType $order = null)
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get Order value
     * @return \StructType\OrderKeyType
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderKeyType $order
     * @return \StructType\OrderClosingNotifRequestType
     */
    public function setOrder(\StructType\OrderKeyType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
}
