<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionalPaxSegmentListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Segment data list definition.
 * @subpackage Structs
 */
class OptionalPaxSegmentListType extends AbstractStructBase
{
    /**
     * The PaxSegment
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxSegmentType[]
     */
    public $PaxSegment;
    /**
     * Constructor method for OptionalPaxSegmentListType
     * @uses OptionalPaxSegmentListType::setPaxSegment()
     * @param \StructType\PaxSegmentType[] $paxSegment
     */
    public function __construct(array $paxSegment = array())
    {
        $this
            ->setPaxSegment($paxSegment);
    }
    /**
     * Get PaxSegment value
     * @return \StructType\PaxSegmentType[]|null
     */
    public function getPaxSegment()
    {
        return $this->PaxSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentForArrayConstraintsFromSetPaxSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionalPaxSegmentListTypePaxSegmentItem) {
            // validation for constraint: itemType
            if (!$optionalPaxSegmentListTypePaxSegmentItem instanceof \StructType\PaxSegmentType) {
                $invalidValues[] = is_object($optionalPaxSegmentListTypePaxSegmentItem) ? get_class($optionalPaxSegmentListTypePaxSegmentItem) : sprintf('%s(%s)', gettype($optionalPaxSegmentListTypePaxSegmentItem), var_export($optionalPaxSegmentListTypePaxSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegment property can only contain items of type \StructType\PaxSegmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentType[] $paxSegment
     * @return \StructType\OptionalPaxSegmentListType
     */
    public function setPaxSegment(array $paxSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentArrayErrorMessage = self::validatePaxSegmentForArrayConstraintsFromSetPaxSegment($paxSegment))) {
            throw new \InvalidArgumentException($paxSegmentArrayErrorMessage, __LINE__);
        }
        $this->PaxSegment = $paxSegment;
        return $this;
    }
    /**
     * Add item to PaxSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentType $item
     * @return \StructType\OptionalPaxSegmentListType
     */
    public function addToPaxSegment(\StructType\PaxSegmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxSegmentType) {
            throw new \InvalidArgumentException(sprintf('The PaxSegment property can only contain items of type \StructType\PaxSegmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegment[] = $item;
        return $this;
    }
}
