<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionalOriginDestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
 * @subpackage Structs
 */
class OptionalOriginDestType extends AbstractStructBase
{
    /**
     * The OriginDestID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies an Origin Destination within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OriginDestID;
    /**
     * The DestCode
     * Meta information extracted from the WSDL
     * - documentation: IATA defined code identifying a city or station. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestCode;
    /**
     * The OriginCode
     * Meta information extracted from the WSDL
     * - documentation: IATA defined code identifying a city or station. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginCode;
    /**
     * The PaxJourneyRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Journey within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxJourneyRefID;
    /**
     * Constructor method for OptionalOriginDestType
     * @uses OptionalOriginDestType::setOriginDestID()
     * @uses OptionalOriginDestType::setDestCode()
     * @uses OptionalOriginDestType::setOriginCode()
     * @uses OptionalOriginDestType::setPaxJourneyRefID()
     * @param string $originDestID
     * @param string $destCode
     * @param string $originCode
     * @param string[] $paxJourneyRefID
     */
    public function __construct($originDestID = null, $destCode = null, $originCode = null, array $paxJourneyRefID = array())
    {
        $this
            ->setOriginDestID($originDestID)
            ->setDestCode($destCode)
            ->setOriginCode($originCode)
            ->setPaxJourneyRefID($paxJourneyRefID);
    }
    /**
     * Get OriginDestID value
     * @return string
     */
    public function getOriginDestID()
    {
        return $this->OriginDestID;
    }
    /**
     * Set OriginDestID value
     * @param string $originDestID
     * @return \StructType\OptionalOriginDestType
     */
    public function setOriginDestID($originDestID = null)
    {
        // validation for constraint: string
        if (!is_null($originDestID) && !is_string($originDestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDestID, true), gettype($originDestID)), __LINE__);
        }
        $this->OriginDestID = $originDestID;
        return $this;
    }
    /**
     * Get DestCode value
     * @return string|null
     */
    public function getDestCode()
    {
        return $this->DestCode;
    }
    /**
     * Set DestCode value
     * @param string $destCode
     * @return \StructType\OptionalOriginDestType
     */
    public function setDestCode($destCode = null)
    {
        // validation for constraint: string
        if (!is_null($destCode) && !is_string($destCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destCode, true), gettype($destCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($destCode) && mb_strlen($destCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($destCode)), __LINE__);
        }
        $this->DestCode = $destCode;
        return $this;
    }
    /**
     * Get OriginCode value
     * @return string|null
     */
    public function getOriginCode()
    {
        return $this->OriginCode;
    }
    /**
     * Set OriginCode value
     * @param string $originCode
     * @return \StructType\OptionalOriginDestType
     */
    public function setOriginCode($originCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCode) && !is_string($originCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCode, true), gettype($originCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($originCode) && mb_strlen($originCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($originCode)), __LINE__);
        }
        $this->OriginCode = $originCode;
        return $this;
    }
    /**
     * Get PaxJourneyRefID value
     * @return string[]|null
     */
    public function getPaxJourneyRefID()
    {
        return $this->PaxJourneyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxJourneyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxJourneyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxJourneyRefIDForArrayConstraintsFromSetPaxJourneyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionalOriginDestTypePaxJourneyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($optionalOriginDestTypePaxJourneyRefIDItem)) {
                $invalidValues[] = is_object($optionalOriginDestTypePaxJourneyRefIDItem) ? get_class($optionalOriginDestTypePaxJourneyRefIDItem) : sprintf('%s(%s)', gettype($optionalOriginDestTypePaxJourneyRefIDItem), var_export($optionalOriginDestTypePaxJourneyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxJourneyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxJourneyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxJourneyRefID
     * @return \StructType\OptionalOriginDestType
     */
    public function setPaxJourneyRefID(array $paxJourneyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxJourneyRefIDArrayErrorMessage = self::validatePaxJourneyRefIDForArrayConstraintsFromSetPaxJourneyRefID($paxJourneyRefID))) {
            throw new \InvalidArgumentException($paxJourneyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxJourneyRefID = $paxJourneyRefID;
        return $this;
    }
    /**
     * Add item to PaxJourneyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OptionalOriginDestType
     */
    public function addToPaxJourneyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxJourneyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxJourneyRefID[] = $item;
        return $this;
    }
}
